# Categories {#funcs_by_topics}

DolphinDB's functions can be divided into the following categories according to their functionality:

**Parent topic:**[Function References](../Functions/chap_function_references.md)

## Data Manipulation {#data_operations_funcs_by_topics}

-   **Data Types and Conversion:**[array](a/array.md), [arrayVector](a/arrayVector.md), [bigarray](b/bigarray.md), [bool](b/bool.md), [blob](b/blob.md), [cast](c/cast.md), [ceil](c/ceil.md), [char](c/char.md), [complex](c/complex.md), [date](d/date.md), [datehour](d/datehour.md), [datetime](d/datetime.md), [decimal32](d/decimal32.md), [decimal64](d/decimal64.md), [decimal128](d/decimal128.md), [decimalFormat](d/decimalFormat.md), [decimalMultiply](d/decimalMultiply.md), [deg2rad](d/deg2rad.md), [dict](d/dict.md), [double](d/double.md), [duration](d/duration.md), [enlist](e/enlist.md), [fixedLengthArrayVector](f/fixedLengthArrayVector.md), [floor](f/floor.md), [form](f/form.md), [format](f/format.md), [fromJson](f/fromJson.md), [parseJsonTable](p/parseJsonTable.md),[hex](h/hex.md), [highDouble](h/highDouble.md), [highLong](h/highlong.md), [int](i/int.md), [int128](i/int128.md), [ipaddr](i/ipaddr.md), [isOrderedDict](i/isOrderedDict.md), [long](l/long.md), [lowDouble](l/lowDouble.md),[lowLong](l/lowlong.md), [makeKey](m/makeKey.md), [makeSortedKey](m/makeSortedKey.md)**,** [matrix](m/matrix.md), [minute](m/minute.md), [month](m/month.md), [nanotime](n/nanotime.md), [nanotimestamp](n/nanotimestamp.md), [pair](p/pair.md), [point](p/point.md), [rad2deg](r/rad2deg.md), [round](r/round.md), [second](s/second.md), [seq](s/seq.md), [set](s/set.md), [short](s/short.md), [string](s/string.md), [subtuple](s/subtuple.md), [symbol](s/symbol.md), [syncDict](s/syncDict.md), [temporalFormat](t/temporalFormat.md), [temporalParse](t/temporalParse.md), [time](t/time.md), [timestamp](t/timestamp.md), [toJson](t/toJson.md), [toStdJson](t/toStdJson.md), [type](t/type.md), [typestr](t/typestr.md), [uuid](u/uuid.md), [indexedSeries](i/indexedSeries.md), [isIndexedSeries](i/isIndexedSeries.md), [isIndexedMatrix](i/isIndexedMatrix.md), [setIndexedMatrix!](s/setIndexedMatrix!.md), [setIndexedSeries!](s/setIndexedSeries!.md), [reverse](r/reverse.md), [transpose](t/transpose.md)/[flip](f/flip.md), [symbolCode](s/symbolCode.md), [parseInteger](p/parseInteger.md), [fromStdJson](f/fromStdJson.md), [jsonExtract](j/JsonExtract.md)

-   **Creation:** [take](t/take.md), [til](t/til.md), [stretch](s/stretch.md), [seq](s/seq.md), [eye](e/eye.md), [panel](p/panel.md), [rollingPanel](r/rollingPanel.md)

-   **Appending:**[append!](a/append!.md)/[push!](p/push!.md), [appendTuple!](a/appendtuple.md), [memberModify!](m/memberModify!.md)

-   **Deletion, Cleanup:**[removeHead!](r/removeHead!.md), [removeTail!](r/removeTail!.md), [pop!](p/pop!.md), [drop](d/drop.md), [dropna](d/dropna.md), [clear!](c/clear!.md), [erase!](e/erase!.md)

-   **Finding:**[tail](t/tail.md), [head](h/head.md), [subarray](s/subarray.md), [first](f/first.md), [firstNot](f/firstNot.md), [ifirstNot](i/ifirstNot.md), [firstNot](f/firstNot.md), [firstHit](f/firstHit.md), [ifirstNot](i/ifirstNot.md), [ifirstHit](i/ifirstHit.md), [last](l/last.md), [lastNot](l/lastNot.md), [ilastNot](i/ilastNot.md), [milastNot](m/milastNot.md), [lastNot](l/lastNot.md), [ilastNot](i/ilastNot.md), [col](c/col.md), [row](r/row.md), [at](a/at.md), [loc](l/loc.md), [eachAt\(@\)](../Programming/Operators/OperatorReferences/eachAt.md), [binsrch](b/binsrch.md), [find](f/find.md), [searchK](s/searchK.md), [slice](s/slice.md), [sliceByKey](s/sliceByKey.md), [cell](c/cell.md), [cells](c/cells.md)

-   **Sorting:**[sort](s/sort.md), [sort!](s/sort!.md), [sortBy!](s/sortBy!.md), [isort](i/isort.md), [isort!](i/isort!.md), [isortTop](i/isortTop.md), [rank](r/rank.md), [denseRank](d/denseRank.md), [isSorted](i/isSorted.md)

-   **Null Value Handling:**[hasNull](h/hasNull.md), [isNothing](i/isNothing.md), [isNull](i/isNull.md), [isValid](i/isValid.md), [isVoid](i/isVoid.md), [isNanInf](i/isNanInf.md), [ifNull](i/ifNull.md), [ifValid](i/ifValid.md), [fill](b/bfill.md), [bfill!](b/bfill!.md), [ffill](f/ffill.md), [ffill!](f/ffill!.md), [interpolate](i/interpolate.md), [nullFill](n/nullFill.md), [nullFill!](n/nullFill!.md), [fill!](f/fill!.md), [lfill](l/lfill.md), [lfill!](l/lfill!.md), [nanInfFill](n/nanInfFill.md)

-   **Replacement:**[replace](r/replace.md), [replace!](r/replace!.md)

-   **Shifting:**[move](m/move.md), [next](n/next.md), [prev](p/prev.md), [prevState](p/prevState.md), [nextState](n/nextState.md), [lshift](l/lshift.md), [rshift](r/rshift.md)

-   **Joining:**[join](j/join.md), [join!](j/join!.md), [merge](m/merge.md), [concatMatrix](c/concatMatrix.md), [union](u/union.md), [unionAll](u/unionAll.md)

-   **Cutting:**[cut](c/cut.md)

-   **Filtering:**[conditionalFilter](c/conditionalFilter.md)

-   **Alignment:**[align](a/align.md)

-   **Rearrangement:**[flatten](f/flatten.md), [shuffle](s/shuffle.md), [shuffle!](s/shuffle!.md), [reshape](r/reshape.md), [regroup](r/regroup.md), [ungroup](u/ungroup.md)

-   **Grouping:**[bucket](b/bucket.md), [groups](g/groups.md), [segment](s/segment.md), [cutPoints](c/cutPoints.md), [bar](b/bar.md), [dailyAlignedBar](d/dailyAlignedBar.md), [volumeBar](v/volumeBar.md), [digitize](d/digitize.md)

-   **Loading:**[loadNpy](l/loadNpy.md), [loadNpz](l/loadNpz.md), [loadRecord](l/loadRecord.md), [loadTable](l/loadTable.md), [loadText](l/loadText.md), [loadTextEx](l/loadTextEx.md), [ploadText](p/ploadText.md)

-   **Encoding:**[compress](c/compress.md), [decompress](d/decompress.md), [oneHot](o/oneHot.md), [base64Decode](b/base64Decode.md), [base64Encode](b/base64Encode.md), [encodeShortGenomeSeq](e/encodeShortGenomeSeq.md), [decodeShortGenomeSeq](d/decodeShortGenomeSeq.md), [genShortGenomeSeq](g/genShortGenomeSeq.md),[pack](p/pack.md), [unpack](u/unpack.md), [rdp](r/rdp.md)

-   **Cumulative Window:**[cumavg](c/cumavg.md), [cumbeta](c/cumbeta.md), [cumcorr](c/cumcorr.md), [cumcount](c/cumcount.md), [cumcovar](c/cumcovar.md), [cummax](c/cummax.md), [cummed](c/cummed.md), [cummin](c/cummin.md), [cumpercentile](c/cumpercentile.md), [cumPositiveStreak](c/cumPositiveStreak.md), [cumprod](c/cumprod.md), [cumrank](c/cumrank.md), [cumdenseRank](c/cumdenseRank.md), [cumstd](c/cumstd.md), [cumstdp](c/cumstdp.md), [cumsum](c/cumsum.md), [cumsum2](c/cumsum2.md), [cumsum3](c/cumsum3.md), [cumsum4](c/cumsum4.md), [cumvar](c/cumvar.md), [cumvarp](c/cumvarp.md), [cumwavg](c/cumwavg.md), [cumwsum](c/cumwsum.md), [cumfirstNot](c/cumfirstNot.md), [cumlastNot](c/cumlastNot.md), [cumnunique](c/cumnunique.md), [dynamicGroupCumsum](d/dynamicGroupCumsum.md), [dynamicGroupCumcount](d/dynamicGroupCumcount.md)

-   **Moving:**[mavg](m/mavg.md), [mbeta](m/mbeta.md), [mcorr](m/mcorr.md), [mcount](m/mcount.md), [mcovar](m/mcovar.md), [mfirst](m/mfirst.md), [mimax](m/mimax.md), [mimin](m/mimin.md), [mkurtosis](m/mkurtosis.md), [mlast](m/mlast.md), [mmad](m/mmad.md), [mmax](m/mmax.md), [mmaxPositiveStreak](m/mmaxPositiveStreak.md), [mmed](m/mmed.md), [mmin](m/mmin.md), [mmse](m/mmse.md), [mpercentile](m/mpercentile.md), [mprod](m/mprod.md), [mrank](m/mrank.md), [mskew](m/mskew.md), [mslr](m/mslr.md), [mstd](m/mstd.md), [mstdp](m/mstdp.md), [msum](m/msum.md), [msum2](m/msum2.md), [mvar](m/mvar.md), [mvarp](m/mvarp.md), [mwavg](m/mwavg.md), [mwsum](m/mwsum.md), [mlastNot](m/mlastNot.md), [mifirstNot](m/mifirstNot.md), [mifirstNot](m/mifirstNot.md), [milastNot](m/milastNot.md), [movingWindowIndex](m/movingWindowIndex.md), [movingTopNIndex](m/movingTopNIndex.md), [mfirstNot](m/mifirstNot.md), [mlastNot](m/mlastNot.md), [mLowRange](m/mLowRange.md), [mTopRange](m/mTopRange.md)

-   **Time-Based Moving:** [tmavg](t/tmavg.md), [tmbeta](t/tmbeta.md), [tmcorr](t/tmcorr.md), [tmcount](t/tmcount.md), [tmcovar](t/tmcovar.md), [tmfirst](t/tmfirst.md), [tmkurtosis](t/tmkurtosis.md), [tmlast](t/tmlast.md), [tmmax](t/tmmax.md), [tmmed](t/tmmed.md), [tmmin](t/tmmin.md), [tmpercentile](t/tmpercentile.md), [tmprod](t/tmprod.md), [tmrank](t/tmrank.md), [tmskew](t/tmskew.md), [tmstd](t/tmstd.md), [tmstdp](t/tmstdp.md), [tmsum](t/tmsum.md), [tmsum2](t/tmsum2.md), [tmvar](t/tmvar.md), [tmvarp](t/tmvarp.md), [tmwavg](t/tmwavg.md), [tmwsum](t/tmwsum.md), [tmTopRange](t/tmTopRange.md), [tmLowRange](t/tmLowRange.md)

-   **mTopN:**[msumTopN](m/msumTopN.md), [mavgTopN](m/mavgTopN.md), [mstdpTopN](m/mstdpTopN.md), [mstdTopN](m/mstdTopN.md), [mvarTopN](m/mvarTopN.md), [mvarpTopN](m/mvarpTopN.md), [mcorrTopN](m/mcorrTopN.md), [mbetaTopN](m/mbetaTopN.md), [mcovarTopN](m/mcovarTopN.md), [mpercentileTopN](m/mpercentileTopN.md),[mwsumTopN](m/mwsumTopN.md),

-   **Row-Based:** [rowSize](r/rowSize.md), [rowAnd](r/rowAnd.md), [rowOr](r/rowOr.md), [rowXor](r/rowXor.md), [rowCount](r/rowCount.md), [rowMax](r/rowMax.md), [rowMin](r/rowMin.md), [rowSum](r/rowSum.md), [rowSum2](r/rowSum2.md), [rowAvg](r/rowAvg.md), [rowRank](r/rowRank.md), [rowDenseRank](r/rowDenseRank.md), [rowProd](r/rowProd.md), [rowSkew](r/rowSkew.md), [rowKurtosis](r/rowKurtosis.md), [rowStd](r/rowStd.md), [rowStdp](r/rowStdp.md), [rowVar](r/rowVar.md), [rowVarp](r/rowVarp.md), [rowCorr](r/rowCorr.md), [rowCovar](r/rowCovar.md), [rowBeta](r/rowBeta.md), [rowWsum](r/rowWsum.md), [rowWavg](r/rowWavg.md), [rowEuclidean](r/rowEuclidean.md), [rowDot](r/rowDot.md), [rowTanimoto](r/rowTanimoto.md), [rowImin](r/rowImin.md), [rowImax](r/rowImax.md), [rowAt](r/rowAt.md), [rowMove](r/rowMove.md), [rowNext](r/rowNext.md), [rowPrev](r/rowPrev.md), [rowAlign](r/rowAlign.md), [rowGmd5](r/rowgmd5.md)

-   **TA-Lib:** [ema](e/ema.md), [ma](m/ma.md), [wma](w/wma.md), [sma](s/sma.md), [trima](t/trima.md), [tema](t/tema.md), [dema](d/dema.md), [gema](g/gema.md), [kama](k/kama.md), [wilder](w/wilder.md), [t3](t/t3.md), [linearTimeTrend](l/linearTimeTrend.md)

-   **String:**[repeat](r/repeat.md), [charAt](c/charAt.md), [left](l/left.md), [right](r/right.md), [ilike](i/ilike.md), [like](l/like.md), [strpos](s/strpos.md), [regexFind](r/regexFind.md), [regexFindStr](r/regexfindstr.md), [concat](c/concat.md), [lpad](l/lpad.md), [rpad](r/rpad.md), [trim](t/trim.md), [ltrim](l/ltrim.md), [rtrim](r/rtrim.md), [strip](s/strip.md), [substr](s/substr.md), [substru](s/substru.md), [split](s/split.md), [toCharArray](t/toCharArray.md), [strlen](s/strlen.md), [strlenu](s/strlenu.md), [regexCount](r/regexCount.md), [regexReplace](r/regexReplace.md), [strReplace](s/strReplace.md), [startsWith](s/startsWith.md), [endsWith](e/endsWith.md), [initcap](i/initcap.md), [upper](u/upper.md), [lower](l/lower.md), [isLower](i/isLower.md), [isUpper](i/isUpper.md), [isTitle](i/isTitle.md), [regexFind](r/regexFind.md), [isSpace](i/isSpace.md), [isAlNum](i/isAlNum.md), [isAlpha](i/isAlpha.md), [isNumeric](i/isNumeric.md), [isDigit](i/isDigit.md), [toUTF8](t/toUTF8.md), [fromUTF8](f/fromUTF8.md), [convertEncode](c/convertEncode.md), [stringFormat](s/stringFormat.md), [md5](m/md5.md), [crc32](c/crc32.md), [gmd5](g/gmd5.md)

-   **Time:**[listAllMarkets](l/listAllMarkets.md), [localtime](l/localtime.md), [gmtime](g/gmtime.md), [convertTZ](c/convertTZ.md), [now](n/now.md), [today](t/today.md), [daysInMonth](d/daysInMonth.md), [year](y/year.md), [month](m/month.md), [date](d/date.md), [weekday](w/weekday.md), [businessDay](b/businessDay.md), [hour](h/hour.md), [microsecond](m/microsecond.md), [millisecond](m/millisecond.md), [nanosecond](n/nanosecond.md), [yearBegin](y/yearBegin.md), [yearEnd](y/yearEnd.md), [quarterBegin](q/quarterBegin.md), [quarterEnd](q/quarterEnd.md), [monthBegin](m/monthBegin.md), [monthEnd](m/monthEnd.md), [semiannualBegin](s/semiannualBegin.md), [semiannualEnd](s/semiannualEnd.md), [semiMonthBegin](s/semiMonthBegin.md), [semiMonthEnd](s/semiMonthEnd.md), [weekBegin](w/weekBegin.md), [weekEnd](w/weekEnd.md), [businessMonthBegin](b/businessMonthBegin.md), [businessMonthEnd](b/businessMonthEnd.md), [businessQuarterBegin](b/businessQuarterBegin.md), [businessQuarterEnd](b/businessQuarterEnd.md), [businessYearBegin](b/businessYearBegin.md), [businessYearEnd](b/businessYearEnd.md), [weekOfMonth](w/weekOfMonth.md), [weekOfYear](w/weekOfYear.md), [monthOfYear](m/monthOfYear.md), [hourOfDay](h/hourOfDay.md), [minuteOfHour](m/minuteOfHour.md), [secondOfMinute](s/secondOfMinute.md), [lastWeekOfMonth](l/lastWeekOfMonth.md), [dayOfMonth](d/dayOfMonth.md), [dayOfWeek](d/dayOfWeek.md), [dayOfYear](d/dayOfYear.md), [fy5253](f/fy5253.md), [fy5253Quarter](f/fy5253Quarter.md), [concatDateTime](c/concatDateTime.md), [asFreq](a/asFreq.md), [transFreq](t/transFreq.md), [temporalSeq](t/temporalSeq.md), [temporalAdd](t/temporalAdd.md), [temporalDeltas](t/temporalDeltas.md), [temporalDiff](t/temporalDiff.md), [isLeapYear](i/isLeapYear.md), [isMonthStart](i/isMonthStart.md), [isMonthEnd](i/isMonthEnd.md), [isQuarterStart](i/isQuarterStart.md), [isQuarterEnd](i/isQuarterEnd.md), [isYearStart](i/isYearStart.md), [isYearEnd](i/isYearEnd.md), [addMarketHoliday](a/addMarketHoliday.md), [updateMarketHoliday](u/updateMarketHoliday.md), [getMarketCalendar](g/getMarketCalendar.md)


## Database/Table {#funcs_by_topics_db_tb}

-   **Database/Table Management:**[existsDatabase](e/existsDatabase.md), [existsPartition](e/existsPartition.md), [existsTable](e/existsTable.md), [database](d/database.md), [dropDatabase](d/dropDatabase.md), [saveDatabase](s/saveDatabase.md), [setAtomicLevel](s/setAtomicLevel.md), [setChunkLastUpdateTime](s/setChunkLastUpdateTime.md), [setOLAPCacheEngineSize](s/setOLAPCacheEngineSize.md), [getOLAPCacheEngineSize](g/getOLAPCacheEngineSize.md), [setTSDBCacheEngineSize](s/setTSDBCacheEngineSize.md), [getTSDBCacheEngineSize](g/getTSDBCacheEngineSize.md), [setMaxMemSize](s/setMaxMemSize.md), [setReservedMemSize](s/setReservedMemSize.md), [setMaxBlockSizeForReservedMemory](s/setMaxBlockSizeForReservedMemory.md), [setMemLimitOfTaskGroupResult](s/setMemLimitOfTaskGroupResult.md), [getLocalIOTDBStaticTable](g/getLocalIOTDBStaticTable.md), [getMemLimitOfTaskGroupResult](g/getMemLimitOfTaskGroupResult.md), [setMemLimitOfQueryResult](s/setMemLimitOfQueryResult.md), [getMemLimitOfQueryResult](g/getMemLimitOfQueryResult.md), [resetRecoveryWorkerNum](r/resetRecoveryWorkerNum.md), [getRecoveryWorkerNum](g/getRecoveryWorkerNum.md), [getRecoveryTaskStatus](g/getRecoveryTaskStatus.md), [enableActivePartition](e/enableActivePartition.md), [disableActivePartition](d/disableActivePartition.md), [enableTSDBAsyncSorting](e/enableTSDBAsyncSorting.md), [disableTSDBAsyncSorting](d/disableTSDBAsyncSorting.md), [enableQueryMonitor](e/enableQueryMonitor.md), [disableQueryMonitor](d/disableQueryMonitor.md), [setMaxConnections](s/setMaxConnections.md), [columnNames](c/columnNames.md), [rowNames](r/rowNames.md), [table](t/table.md), [cachedTable](c/cachedTable.md), [createTable](c/createTable.md), [createDimensionTable](c/createDimensionTable.md), [createPartitionedTable](c/createPartitionedTable.md), [createDistributedInMemoryTable](c/createDistributedInMemoryTable.md), [createIPCInMemoryTable](c/createIPCInMemoryTable.md), [indexedTable](i/indexedTable.md), [keyedTable](k/keyedTable.md), [latestIndexedTable](l/latestIndexedTable.md), [latestKeyedTable](l/latestKeyedTable.md), [mvccTable](m/mvccTable.md), [dropTable](d/dropTable.md), [dropDistributedInMemoryTable](d/dropDistributedInMemoryTable.md), [dropIPCInMemoryTable](d/dropIPCInMemoryTable.md), [loadDistributedInMemoryTable](l/loadDistributedInMemoryTable.md), [loadIPCInMemoryTable](l/loadIPCInMemoryTable.md), [loadTableBySQL](l/loadTableBySQL.md), [loadMvccTable](l/loadMvccTable.md), [saveTable](s/saveTable.md), [savePartition](s/savePartition.md), [saveDualPartition](s/saveDualPartition.md), [rename!](r/rename!.md), [renameTable](r/renameTable.md), [rowNo](r/rowNo.md), [setColumnComment](s/setColumnComment.md), [replay](r/replay.md), [schema](s/schema.md), [getConfigure](g/getConfig.md)/[getConfig](g/getConfig.md), [getAllDBs](g/getAllDBs.md), [getTables](g/getTables.md), [getTablet](g/getTablet.md), [getTabletsMeta](g/getTabletsMeta.md), [getTSDBMetaData](g/getTSDBMetaData.md), [getDFSDatabases](g/getDFSDatabases.md), [getClusterDFSDatabases](g/getClusterDFSDatabases.md), [getDFSTablesByDatabase](g/getDFSTablesByDatabase.md), [getClusterDFSTables](g/getClusterDFSTables.md), [getChunkPath](g/getChunkPath.md), [getChunksMeta](g/getChunksMeta.md), [getClusterChunksStatus](g/getClusterChunksStatus.md), [getFunctionViews](g/getFunctionViews.md), [getTSDBCompactionTaskStatus](g/getTSDBCompactionTaskStatus.md), [getOLAPCachedSymbolBaseMemSize](g/getOLAPCachedSymbolBaseMemSize.md), [getTSDBCachedSymbolBaseMemSize](g/getTSDBCachedSymbolBaseMemSize.md), [getTransactionStatus](g/getTransactionStatus.md), [getUnresolvedTxn](g/getUnresolvedTxn.md), [getAllDBGranularity](g/getAllDBGranularity.md), [triggerTSDBCompaction](t/triggerTSDBCompaction.md), [flushTSDBCache](f/flushTSDBCache.md), [purgeCacheEngine](p/purgeCacheEngine.md) / [flushOLAPCache](f/flushOLAPCache.md), [getLevelFileIndexCacheStatus](g/getLevelFileIndexCacheStatus.md), [getOLAPCacheEngineStat](g/getOLAPCacheEngineStat.md), [getTSDBCacheEngineSize](g/getTSDBCacheEngineSize.md), [getRedoLogGCStat](g/getRedoLogGCStat.md), [addFunctionView](a/addFunctionView.md), [dropFunctionView](d/dropFunctionView.md), [addRangePartitions](a/addRangePartitions.md), [addValuePartitions](a/addValuePartitions.md), [dropPartition](d/dropPartition.md), [extractTextSchema](e/extractTextSchema.md), [tableInsert](t/tableInsert.md), [addColumn](a/addColumn.md), [update!](u/update!.md), [upsert!](u/upsert!.md), [tableUpsert](t/tableupsert.md), [reorderColumns!](r/reorderColumns!.md), [replaceColumn!](r/replaceColumn!.md), [dropColumns!](d/dropColumns!.md), [truncate](t/truncate.md), [imr](i/imr.md), [mr](m/mr.md), [tupleSum](t/tupleSum.md), [cacheDS!](c/cacheDS!.md), [cacheDSNow](c/cacheDSNow.md), [clearDSCache!](c/clearDSCache!.md), [clearDSCacheNow](c/clearDSCacheNow.md), [multiTableRepartitionDS](m/multiTableRepartitionDS.md), [textChunkDS](t/textChunkDS.md), [repartitionDS](r/repartitionDS.md), [replayDS](r/replayDS.md), [sqlDS](s/sqlDS.md), [transDS!](t/transDS!.md), [backup](b/backup.md), [backupDB](b/backupDB.md), [backupTable](b/backupTable.md), [migrate](m/migrate.md), [restore](r/restore.md), [restoreDB](r/restoreDB.md), [restoreTable](r/restoreTable.md), [loadBackup](l/loadBackup.md), [getBackupList](g/getBackupList.md), [getBackupMeta](g/getBackupMeta.md), [getBackupStatus](g/getBackupStatus.md), [checkBackup](c/checkBackup.md), [setMemLimitOfTempResult](s/setMemLimitOfTempResult.md),, [clearAllTSDBSymbolBaseCache](c/clearAllTSDBSymbolBaseCache.md), [setTableComment](s/setTableComment.md), [latestKeyedStreamTable](l/latestKeyedStreamTable.md), [getPKEYMetaData](g/getPKEYMetaData.md), [getPKEYCompactionTaskStatus](g/getPKEYCompactionTaskStatus.md)

-   **Catalog:**[createCatalog](c/createCatalog.md), [createSchema](c/createSchema.md), [dropCatalog](d/dropCatalog.md), [dropSchema](d/dropSchema.md), [existsCatalog](e/existsCatalog.md), [getCurrentCatalog](g/getCurrentCatalog.md), [getAllCatalogs](g/getAllCatalogs.md), [getSchemaByCatalog](g/getSchemaByCatalog.md), [renameCatalog](r/renameCatalog.md), [renameSchema](r/renameSchema.md), [setDefaultCatalog](s/setDefaultCatalog.md)

-   **Cluster Management:**[addNode](a/addNode.md), [removeNode](r/removeNode.md), [addVolumes](a/addVolumes.md), [startDataNode](s/startDataNode.md), [stopDataNode](s/stopDataNode.md), [triggerNodeReport](t/triggerNodeReport.md), [suspendRecovery](s/suspendRecovery.md), [resumeRecovery](r/resumeRecovery.md), [cancelRecoveryTask](c/cancelRecoveryTask.md), [rebalanceChunksAmongDataNodes](r/rebalanceChunksAmongDataNodes.md), [ebalanceChunksWithinDataNode](r/rebalanceChunksWithinDataNode.md), [restoreDislocatedTablet](r/restoreDislocatedTablet.md), [copyReplicas](c/copyReplicas.md), [deleteReplicas](d/deleteReplicas.md), [moveReplicas](m/moveReplicas.md), [startClusterReplication](s/startClusterReplication.md), [stopClusterReplication](s/stopClusterReplication.md), [skipClusterReplicationTask](s/skipClusterReplicationTask.md), [getMasterReplicationStatus](g/getMasterReplicationStatus.md), [getSlaveReplicationStatus](g/getSlaveReplicationStatus.md), [getSlaveReplicationQueueStatus](g/getSlaveReplicationQueueStatus.md), [setDatabaseForClusterReplication](s/setDatabaseForClusterReplication.md), [getDatabaseClusterReplicationStatus](g/getDatabaseClusterReplicationStatus.md), [getRecentSlaveReplicationInfo](g/getRecentSlaveReplicationInfo.md), [moveChunksAcrossVolume](m/moveChunksAcrossVolume.md), [resetDBDirMeta](r/resetDBDirMeta.md), [pnodeRun](p/pnodeRun.md), [getActiveMaster](g/getActiveMaster.md), [getConnections](g/getConnections.md), [getNodeAlias](g/getNodeAlias.md), [getNodeHost](g/getNodeHost.md), [getNodePort](g/getNodePort.md), [getNodeType](g/getNodeType.md), [getActiveMaster](g/getActiveMaster.md), [isControllerInitialized](i/isControllerInitialized.md), [isDataNodeInitialized](i/isDataNodeInitialized.md), [xdb](x/xdb.md), [rpc](r/rpc.md), [remoteRun](r/remoteRun.md), [remoteRunCompatible](r/remoteRunCompatible.md), [remoteRunWithCompression](r/remoteRunWithCompression.md), [setTimeoutTick](s/setTimeoutTick.md)

-   **Multi-Cluster Management:**[getAllClusters](g/getAllClusters.md), [getCatalogsByCluster](g/getCatalogsByCluster.md), [getClusterStatus](g/getClusterStatus.md), [getDatabasesByCluster](g/getDatabasesByCluster.md), [getGroupAccessByCluster](g/getGroupAccessByCluster.md), [getGroupListOfAllClusters](g/getGroupListOfAllClusters.md), [getSchemasByCluster](g/getSchemasByCluster.md), [getTableAccessByCluster](g/getTableAccessByCluster.md), [getTablesByCluster](g/getTablesByCluster.md), [getTablesOfAllClusters](g/getTablesOfAllClusters.md), [getTableSchemaByCluster](g/getTableSchemaByCluster.md), [getUserAccessByCluster](g/getUserAccessByCluster.md), [getUserListOfAllClusters](g/getUserListOfAllClusters.md), [listPluginsByCluster](l/listPluginsByCluster.md)
-   **Compute Group:**[clearComputeNodeCache](c/clearComputeNodeCache.md), [getComputeNodeCachingDelay](g/getComputeNodeCachingDelay.md), [clearComputeNodeDiskCache](c/clearcomputenodediskcache.md), [flushComputeNodeMemCache](f/flushComputeNodeMemCache.md), [getComputeGroupChunksStatus](g/getComputeGroupChunksStatus.md), [getComputeNodeCacheDetails](g/getComputeNodeCacheDetails.md), [getComputeNodeCacheStat](g/getComputeNodeCacheStat.md), [getPrefetchComputeNodeData](g/getPrefetchComputeNodeData.md), [getComputeNodeCacheWarmupJobStatus](g/getcomputenodecachewarmupjobstatus.md), [setComputeNodeCachingDelay](s/setComputeNodeCachingDelay.md), [setPrefetchComputeNodeData](s/setPrefetchComputeNodeData.md), [warmupComputeNodeCache](w/warmupcomputenodecache.md)


## SQL {#funcs_by_topics_sql}

-   **Keywords:**[select](../Programming/SQLStatements/select.md), [create](../Programming/SQLStatements/create.md), [alter](../Programming/SQLStatements/alter.md), [any/all](../Programming/SQLStatements/any.md), [case](../Programming/SQLStatements/case.md), [exec](../Programming/SQLStatements/exec.md), [coalesce](../Programming/SQLStatements/coalesce.md), [where](../Programming/SQLStatements/where.md), [having](../Programming/SQLStatements/having.md), [nullIf](../Programming/SQLStatements/nullIf.md), [top](../Programming/SQLStatements/top.md), [limit](../Programming/SQLStatements/limit.md), [sample](../Programming/SQLStatements/sample.md), [delete](../Programming/SQLStatements/delete.md), [distinct](../Programming/SQLStatements/distinct.md), [insert into](../Programming/SQLStatements/insertInto.md), [update](../Programming/SQLStatements/update.md), [drop](../Programming/SQLStatements/drop.md), [pivot by](../Programming/SQLStatements/pivotBy.md), [context by](../Programming/SQLStatements/contextBy.md), [cgroup by](../Programming/SQLStatements/cgroupby.md), [group by](../Programming/SQLStatements/groupby.md), [order by](../Programming/SQLStatements/orderby.md), [partition](../Programming/SQLStatements/partition.md), [unpivot](u/unpivot.md), [interval](../Programming/SQLStatements/interval.md), [map](../Programming/SQLStatements/map.md), [union/union all](../Programming/SQLStatements/union.md), [with](../Programming/SQLStatements/with.md), [is null](../Programming/SQLStatements/isnull.md), [between](../Programming/SQLStatements/between.md), [exists](../Programming/SQLStatements/exists.md), [in](../Programming/SQLStatements/in.md), [like](../Programming/SQLStatements/like.md), \[[HINT\_EXPLAIN\]](../Programming/SQLStatements/hint/hint_explain.md), [SQL Trace](../Programming/SQLStatements/SQLTrace/SQLTrace.md), [notBetween/NOTBETWEEN](../Programming/SQLStatements/notbetween.md), [notIn/NOTIN](../Programming/SQLStatements/notin.md), [notLike/NOTLIKE](../Programming/SQLStatements/notlike.md)

-   **Table Joiners:**[cj](c/cj.md), [ej](../Programming/SQLStatements/TableJoiners/equijoin.md), [sej](../Programming/SQLStatements/TableJoiners/equijoin.md), [lj](../Programming/SQLStatements/TableJoiners/leftjoin.md) \(left join\), [lsj](../Programming/SQLStatements/TableJoiners/leftjoin.md) \(left semi join\), [fj](../Programming/SQLStatements/TableJoiners/fulljoin.md) \(full join\), [right join](../Programming/SQLStatements/TableJoiners/rightjoin.md), [aj](../Programming/SQLStatements/TableJoiners/asofjoin.md), [wj](../Programming/SQLStatements/TableJoiners/windowjoin.md), [pwj](../Programming/SQLStatements/TableJoiners/windowjoin.md), [pj](../Programming/SQLStatements/TableJoiners/prefixjoin.md), [inner join](../Programming/SQLStatements/TableJoiners/innerjoin.md)

-   **Status View:**[setTraceMode](../Programming/SQLStatements/SQLTrace/setTraceMode.md), [getTraces](../Programming/SQLStatements/SQLTrace/getTraces.md), [viewTraceInfo](../Programming/SQLStatements/SQLTrace/viewTraceInfo.md), [getCompletedQueries](g/getCompletedQueries.md), [getRunningQueries](g/getRunningQueries.md), [getQueryStatus](g/getQueryStatus.md)


## Mathematics and Statistics {#funcs_by_topics_math_statis}

-   **Mathematics**: [abs](a/abs.md), [acos](a/acos.md), [acosh](a/acosh.md), [add](a/add.md), [asin](a/asin.md), [asinh](a/asinh.md), [atan](a/atan.md), [atanh](a/atanh.md), [cbrt](c/cbrt.md), [clip](c/clip.md), [clip!](c/clip_.md), [cos](c/cos.md), [cosh](c/cosh.md), [cholesky](c/cholesky.md), [derivative](d/derivative.md), [diag](d/diag.md), [div](d/div.md), [det](d/det.md), [eig](e/eig.md), [exp](e/exp.md), [exp2](e/exp2.md), [expm1](e/expm1.md), [gram](g/gram.md), [gramSchmidt](g/gramSchmidt.md), [integral](i/integral.md), [inverse](i/inverse.md), [intersection](i/intersection.md), [iterate](i/iterate.md), [log](l/log.md), [log10](l/log10.md), [log1p](l/log1p.md), [log2](l/log2.md), [lu](l/lu.md), [mod](m/mod.md), [mul](m/mul.md), [neg](n/neg.md), [pow](p/pow.md), [qr](q/qr.md), [ratio](r/ratio.md), [reciprocal](r/reciprocal.md), [repmat](r/repmat.md), [rms](r/rms.md), [schur](s/schur.md), [signbit](s/signbit.md), [signum](s/signum.md), [sin](s/sin.md), [sinh](s/sinh.md), [sqrt](s/sqrt.md), [square](s/square.md), [sub](s/sub.md), [symmetricDifference](s/symmetricDifference.md), [svd](s/svd.md), [tan](t/tan.md), [tanh](t/tanh.md), [tril](t/tril.md) ,[triu](t/triu.md)
-   **Statistics**: [atImax](a/atImax.md), [atImin](a/atImin.md), [avg](a/avg.md), [boxcox](b/boxcox.md), [contextSum](c/contextSum.md), [contextSum2](c/contextSum2.md), [count](c/count.md), [covar](c/covar.md), [covarMatrix](c/covarMatrix.md), [crossStat](c/crossStat.md), [cubicHermiteSplineFit](c/cubichermitesplinefit.md), [cumnunique](c/cumnunique.md), [demean](d/demean.md), [dot](d/dot.md), [ewmCov](e/ewmCov.md), [ewmMean](e/ewmMean.md), [ewmStd](e/ewmStd.md), [ewmVar](e/ewmVar.md), [gaussianKde](g/gaussianKde.md), [gaussianKdePredict](g/gaussianKdePredict.md), [histogram2d](h/histogram2d.md), [imax](i/imax.md), [imin](i/imin.md), [kroghInterpolateFit](k/kroghInterpolateFit.md), [kurtosis](k/kurtosis.md), [linearInterpolateFit](l/linearInterpolateFit.md), [mad](m/mad.md), [max](m/max.md), [maxIgnoreNull](m/maxIgnoreNull.md), [med](m/med.md), [mean](m/mean.md), [min](m/min.md), [minIgnoreNull](m/minIgnoreNull.md), [mode](m/mode.md),[mmed](m/mmed.md), [nunique](n/nunique.md), [percentChange](p/percentChange.md), [percentile](p/percentile.md), [percentileRank](p/percentileRank.md), [prod](p/prod.md), [quantile](q/quantile.md), [quantileSeries](q/quantileSeries.md), [sem](s/sem.md), [skew](s/skew.md), [std](s/std.md), [stdp](s/stdp.md), [summary](s/summary.md), [sum](s/sum.md), [sum2](s/sum2.md), [sum3](s/sum3.md), [sum4](s/sum4.md), [stat](s/stat.md), [var](v/var.md), [varp](v/varp.md), [wavg](w/wavg.md), [wc](w/wc.md), [wcovar](w/wcovar.md), [wsum](w/wsum.md), [boxcox](b/boxcox.md)
-   **Correlation**: [acf](a/acf.md), [autocorr](a/autocorr.md), [corr](c/corr.md), [corrMatrix](c/corrMatrix.md), [distance](d/distance.md), [ewmCorr](e/ewmCorr.md), [euclidean](e/euclidean.md), [kendall](k/kendall.md), [mutualInfo](m/mutualInfo.md), [rowEuclidean](r/rowEuclidean.md),[rowTanimoto](r/rowTanimoto.md), [spearmanr](s/spearmanr.md), [tanimoto](t/tanimoto.md)
-   **Sequential analysis**: [isMonotonicIncreasing](i/isMonotonicIncreasing.md)[isMonotonic](i/isMonotonic.md)[isMonotonicDecreasing](i/isMonotonicDecreasing.md), [isPeak](i/isPeak.md), [isValley](i/isValley.md), [zigzag](z/zigzag.md)
-   **Distribution and hypothesis testing**: [adfuller](a/adfuller.md),[anova](a/anova.md), [cdfBeta](c/cdfBeta.md), [cdfBinomial](c/cdfBinomial.md), [cdfChiSquare](c/cdfChiSquare.md), [cdfExp](c/cdfExp.md), [cdfF](c/cdfF.md), [cdfGamma](c/cdfGamma.md), [cdfKolmogorov](c/cdfKolmogorov.md), [cdfLogistic](c/cdfLogistic.md), [cdfNormal](c/cdfNormal.md), [cdfPoisson](c/cdfPoisson.md), [cdfStudent](c/cdfStudent.md), [cdfUniform](c/cdfUniform.md), [cdfWeibull](c/cdfWeibull.md), [cdfZipf](c/cdfZipf.md), [chiSquareTest](c/chiSquareTest.md), [coint](c/coint.md),[esd](e/esd.md), [fTest](f/fTest.md), [invBeta](i/invBeta.md), [invBinomial](i/invBinomial.md), [invChiSquare](i/invChiSquare.md), [invExp](i/invExp.md), [invF](i/invF.md), [invGamma](i/invGamma.md), [invLogistic](i/invLogistic.md), [invNormal](i/invNormal.md), [invStudent](i/invStudent.md), [invPoisson](i/invPoisson.md), [invUniform](i/invUniform.md), [invWeibull](i/invWeibull.md), [ksTest](k/ksTest.md), [mannWhitneyUTest](m/mannWhitneyUTest.md), [manova](m/manova.md), [norm](n/norm.md), [normal](n/normal.md), [rand](r/rand.md), [randBeta](r/randBeta.md), [randBinomial](r/randBinomial.md), [randChiSquare](r/randChiSquare.md), [randDiscrete](r/randDiscrete.md), [randExp](r/randExp.md), [randF](r/randF.md), [randGamma](r/randGamma.md), [randLogistic](r/randLogistic.md), [randMultivariateNormal](r/randMultivariateNormal.md), [randNormal](r/randNormal.md), [randPoisson](r/randPoisson.md), [randStudent](r/randStudent.md), [randUniform](r/randUniform.md), [randWeibull](r/randWeibull.md), [seasonalEsd](s/seasonalEsd.md), [shapiroTest](s/shapiroTest.md), [tTest](t/tTest.md), [zTest](z/zTest.md)
-   **Data processing**: [all](a/all.md), [any](a/any.md), [asis](a/asis.md), [asof](a/asof.md), [bucketCount](b/bucketCount.md), [coevent](c/coevent.md), [cols](c/cols.md), [copy](c/copy.md), [contextCount](c/contextCount.md), [countNanInf](c/countNanInf.md), [cumPositiveStreak](c/cumPositiveStreak.md), [deepCopy](d/deepCopy.md), [deltas](d/deltas.md), [dictUpdate!](d/dictUpdate!.md), [differentialEvolution](d/differentialEvolution.md), [distinct](d/distinct.md), [dynamicGroupCumcount](d/dynamicGroupCumcount.md), [dynamicGroupCumsum](d/dynamicGroupCumsum.md), [hashBucket](h/hashBucket.md), [iif](i/iif.md), [imaxLast](i/imaxlast.md), [iminLast](i/iminlast.md), [isDuplicated](i/isDuplicated.md), [keys](k/keys.md), [linearTimeTrend](l/linearTimeTrend.md), [lowerBound](l/lowerBound.md),[lowRange](l/lowRange.md), [mask](m/mask.md), [maxPositiveStreak](m/maxPositiveStreak.md), [mimaxLast](m/mimaxlast.md), [miminLast](m/miminlast.md), [mmaxPositiveStreak](m/mmaxPositiveStreak.md), [pca](p/pca.md), [ratios](r/ratios.md), [resample](r/resample.md), [rowImaxLast](r/rowimaxlast.md), [rowIminLast](r/rowiminlast.md), [rows](r/rows.md), [sessionWindow](s/sessionWindow.md), [shape](s/shape.md), [size](s/size.md), [stl](s/stl.md), [sumbars](s/sumbars.md), [talibNull](t/talibNull.md), [tmove](t/tmove.md), [topRange](t/topRange.md), [valueChanged](v/valueChanged.md), [values](v/values.md), [winsorize!](w/winsorize!.md), [winsorize](w/winsorize.md), [zscore](z/zscore.md)
-   **Interpolation**: [cubicSpline](c/cubicspline.md), [cubicSplinePredict](c/cubicsplinepredict.md), [dividedDifference](d/dividedDifference.md), [kroghInterpolate](k/kroghInterpolate.md), [loess](l/loess.md), [neville](n/neville.md), [pchipInterpolateFit](p/pchipInterpolateFit.md), [spline](s/spline.md), [splrep](s/splrep.md), [splev](s/splev.md)
-   **Optimization**: [brute](b/brute.md), [brentq](b/brentq.md),[fmin](f/fmin.md), [fminBFGS](f/fminBFGS.md), [fminLBFGSB](f/fminLBFGSB.md), [fminNCG](f/fminNCG.md), [fminSLSQP](f/fminSLSQP.md), [linprog](l/linprog.md), [osqp](o/osqp.md), [qclp](q/qclp.md), [quadprog](q/quadprog.md), [scs](s/scs.md), [solve](s/solve.md), [socp](s/socp.md)

## Operators {#funcs_by_topics_operators}

-   **Logical:**[and](a/and.md), [not](n/not.md), [or](../Programming/Operators/OperatorReferences/or.md), [xor](x/xor.md), [bitAnd](b/bitAnd.md), [bitOr](b/bitOr.md), [bitXor](b/bitXor.md)

-   **Relational:**[eq](e/eq.md), [ge](g/ge.md), [le](l/le.md), [gt](g/gt.md), [lt](l/lt.md), [ne](n/ne.md), [in](i/in.md), [between](b/between.md), [eqFloat](e/eqFloat.md), [eqObj](e/eqObj.md), [eqPercent](e/eqPercent.md)


## Streaming {#funcs_by_topics_streaming}

-   [streamTable](s/streamTable.md), [haStreamTable](h/haStreamTable.md), [keyedStreamTable](k/keyedStreamTable.md), [share](../Programming/ProgrammingStatements/share.md), [appendMsg](a/appendMsg.md), [appendForJoin](a/appendForJoin.md), [subscribeTable](s/subscribeTable.md), [unsubscribeTable](u/unsubscribeTable.md), [existsSubscriptionTopic](e/existsSubscriptionTopic.md), [addMetrics](a/addMetrics.md), [dropStreamTable](d/dropStreamTable.md), [clearTablePersistence](c/clearTablePersistence.md), [removeTopicOffset](r/removeTopicOffset.md), [enableTableShareAndPersistence](e/enableTableShareAndPersistence.md), [enableTablePersistence](e/enableTablePersistence.md), [disableTablePersistence](d/disableTablePersistence.md), [setStreamTableFilterColumn](s/setStreamTableFilterColumn.md), [getStreamTables](g/getstreamtables.md), [existsStreamTable](e/existsstreamtable.md), [setStreamTableTimestamp](s/setStreamTableTimestamp.md), [enableTableShareAndCachePurge](e/enableTableShareAndCachePurge.md), [enableTableCachePurge](e/enableTableCachePurge.md)

-   **Streaming Engines:**[createTimeSeriesEngine](c/createTimeSeriesEngine.md), [createAnomalyDetectionEngine](c/createAnomalyDetectionEngine.md), [createAsofJoinEngine](c/createAsofJoinEngine.md), [createCrossSectionalEngine](c/createCrossSectionalEngine.md), [createDailyTimeSeriesEngine](c/createDailyTimeSeriesEngine.md), [createEquiJoinEngine](c/createEquiJoinEngine.md) / [createEqualJoinEngine](c/createEqualJoinEngine.md), [createLeftSemiJoinEngine](c/createLeftSemiJoinEngine.md), [createReactiveStateEngine](c/createReactiveStateEngine.md), [createNarrowReactiveStateEngine](c/createNarrowReactiveStateEngine.md), [createDualOwnershipReactiveStateEngine](c/createDualOwnershipReactiveStateEngine.md), [createSessionWindowEngine](c/createSessionWindowEngine.md), [createSnapshotJoinEngine](c/createSnapshotJoinEngine.md), [createStreamDispatchEngine](c/createStreamDispatchEngine.md), [createRuleEngine](c/createRuleEngine.md), [createWindowJoinEngine](c/createWindowJoinEngine.md), [createLookupJoinEngine](c/createLookupJoinEngine.md), [streamEngineParser](s/streamEngineParser.md), [dropStreamEngine](d/dropStreamEngine.md) / [dropAggregator](d/dropAggregator.md), [warmupStreamEngine](w/warmupStreamEngine.md), [createTimeBucketEngine](c/createTimeBucketEngine.md), createCEPEngine

-   [stateIterate](s/stateIterate.md), [conditionalIterate](c/conditionalIterate.md), [getLeftStream](g/getLeftStream.md)/[getRightStream](g/getRightStream.md), [getStreamEngine](g/getStreamEngine.md)/[getAggregator](g/getAggregator.md), [getStreamEngineStat](g/getStreamEngineStat.md)/[getAggregatorStat](g/getAggregatorStat.md), [getComputeNodeCacheWarmupJobStatus](g/getcomputenodecachewarmupjobstatus.md), [getPersistenceMeta](g/getPersistenceMeta.md), [getSnapshotMsgId](g/getSnapshotMsgId.md), [getStreamEngineList](g/getStreamEngineList.md), [getStreamingStat](g/getStreamingStat.md), [getStreamingLeader](g/getStreamingLeader.md), [getStreamingRaftGroups](g/getStreamingRaftGroups.md), [getStreamTableFilterColumn](g/getStreamTableFilterColumn.md), [getPersistenceMeta](g/getPersistenceMeta.md), [getSnapshotMsgId](g/getSnapshotMsgId.md), [getSubscriptionTopic](g/getSubscriptionTopic.md), [getTopicProcessedOffset](g/getTopicProcessedOffset.md), [addReactiveMetrics](a/addReactiveMetrics.md), [getReactiveMetrics](g/getReactiveMetrics.md), [getRules](g/getRules.md), [getStreamTableCacheOffset](g/getStreamTableCacheOffset.md), [warmupComputeNodeCache](w/warmupcomputenodecache.md)

-   **Streaming SQL:**[declareStreamingSQLTable](d/declareStreamingSQLTable.md), [getStreamingSQLStatus](g/getStreamingSQLStatus.md), [listStreamingSQLTables](l/listStreamingSQLTables.md), [registerStreamingSQL](r/registerStreamingSQL.md), [revokeStreamingSQL](r/revokeStreamingSQL.md), [revokeStreamingSQLTable](r/revokeStreamingSQLTable.md), [subscribeStreamingSQL](s/subscribeStreamingSQL.md), [unsubscribeStreamingSQL](u/unsubscribeStreamingSQL.md)


## Metaprogramming {#funcs_by_topics_metaprogramming}

[eval](e/eval.md), [sql](s/sql.md), [sqlCol](s/sqlCol.md), [sqlColAlias](s/sqlColAlias.md), [sqlDelete](s/sqlDelete.md), [sqlUpdate](s/sqlUpdate.md), [expr](e/expr.md), [parseExpr](p/parseExpr.md), [binaryExpr](b/binaryExpr.md), [unifiedExpr](u/unifiedExpr.md), [funcByName](f/funcByName.md), [makeCall](m/makeCall.md), [makeUnifiedCall](m/makeUnifiedCall.md)

## Higher-Order Functions {#funcs_by_topics_high_order}

[accumulate \(:A\)](Templates/accumulate.md), [aggrTopN](Templates/aggrTopN.md), [all](Templates/all.md), [any](Templates/any.md), [byColumn \(:V\)](Templates/byColumn.md), [byRow \(:H\)](Templates/byRow.md), [call](Templates/call.md), [compose](c/compose.md),[contextby \(:X\)](Templates/contextby.md), [cross \(:C\)](Templates/cross.md)/[pcross](Templates/pcross.md), [each \(:E\)](Templates/each.md), [eachLeft \(:L\)](Templates/eachLeft.md), [eachPre \(:P\)](Templates/eachPre.md), [eachRight \(:R\)](Templates/eachRight.md), [eachPost \(:O\)](Templates/eachPost.md), [groupby \(:G\)](Templates/groupby.md), [loop \(:U\)](Templates/loop.md) / [ploop](Templates/ploop.md), [moving](Templates/moving.md), [nullCompare](Templates/nullCompare.md), [pivot](Templates/pivot.md), [pcall](Templates/pcall.md), [reduce \(:T\)](Templates/reduce.md), [rolling](Templates/rolling.md), [segmentby](Templates/segmentby.md), [talib](Templates/talib.md), [tmoving](Templates/tmoving.md), [twindow](Templates/twindow.md), [window](Templates/window.md), [withNullFill](Templates/withNullFill.md), [unifiedCall](Templates/unifiedCall.md), [rowGroupby](r/rowGroupby.md)

## Financial Analysis {#topic_rz2_h15_4gc}

-   **Financial analysis**:[amortizingFixedRateBondDirtyPrice](a/amortizingfixedratebonddirtyprice.md), [arima](a/arima.md), , , , , [condValueAtRisk](c/condValueAtRisk.md), [convertibleFixedRateBondDirtyPrice](c/convertiblefixedratebonddirtyprice.md), [coint](c/coint.md), [cummdd](c/cummdd.md), [floatingRateBondDirtyPrice](f/floatingratebonddirtyprice.md), [nss](n/nss.md), [ns](n/ns.md), [nssPredict](n/nssPredict.md),[trueRange](t/trueRange.md), [varma](v/varma.md), [valueAtRisk](v/valueAtRisk.md), [maxDrawdown](m/maxDrawdown.md), [cds](c/cds.md), [vanillaOption](v/vanillaOption.md), [irs](i/irs.md)
-   **FICC**: [bondAccrInt](b/bondAccrInt.md)[bondCashflow](b/bondCashflow.md)[bondConvexity](b/bondConvexity.md)[bondDirtyPrice](b/bondDirtyPrice.md), [bondFuturesPricer](b/bondFuturesPricer.md), [bondPricer](b/bondPricer.md), [bondYieldCurveBuilder](b/bondYieldCurveBuilder.md), [curvePredict](c/curvePredict.md), [extractInstrument](e/extractInstrument.md), [fxEuropeanOptionPricer](f/fxEuropeanOptionPricer.md), [fxForwardPricer](f/fxForwardPricer.md), [fxSwapPricer](f/fxSwapPricer.md), [fxVolatilitySurfaceBuilder](f/fxVolatilitySurfaceBuilder.md), [extractMktData](e/extractMktData.md), [instrumentPricer](i/instrumentPricer.md), [irCrossCurrencyCurveBuilder](i/irCrossCurrencyCurveBuilder.md), [irDepositPricer](i/irDepositPricer.md), [irFixedFloatingSwapPricer](i/irFixedFloatingSwapPricer.md), [irSingleCurrencyCurveBuilder](i/irSingleCurrencyCurveBuilder.md), [optionVolPredict](o/optionVolPredict.md), [parseInstrument](p/parseInstrument.md), [parseMktData](p/parseMktData.md), [portfolioPricer](p/portfolioPricer.md)

## Machine Learning {#topic_lt5_bzt_4gc}

-   **Machine learning**: [adaBoostClassifier](a/adaBoostClassifier.md), [adaBoostRegressor](a/adaBoostRegressor.md), [beta](b/beta.md), [bvls](b/bvls.md), [elasticNet](e/elasticNet.md), [elasticNetCV](e/elasticnetcv.md), [garch](g/garch.md), [gaussianNB](g/gaussianNB.md), [glm](g/glm.md), [gmm](g/gmm.md), [kernelRidge](k/kernelRidge.md), [kmeans](k/kmeans.md), [knn](k/knn.md), [lasso](l/lasso.md), [lassoBasic](l/lassoBasic.md), [lassoCV](l/lassocv.md), [logisticRegression](l/logisticRegression.md), [mmse](m/mmse.md), [msl](m/mslr.md), [multinomialNB](m/multinomialNB.md), [ols](o/ols.md), [olsEx](o/olsEx.md), [piecewiseLinFit](p/piecewiseLinFit.md), [poly1d](p/poly1d.md), [polyFit](p/polyFit.md), [polynomial](p/polynomial.md),[polyPredict](p/polyPredict.md), [predict](p/predict.md), [pwlfPredict](p/pwlfPredict.md), [randomForestClassifier](r/randomForestClassifier.md), [randomForestRegressor](r/randomForestRegressor.md), [residual](r/residual.md), [ridge](r/ridge.md), [ridgeBasic](r/ridgebasic.md), [vectorAR](v/vectorAR.md), [wls](w/wls.md)
-   **Text vectorization:**[loadVocab](l/loadVocab.md), [tokenizeBert](t/tokenizeBert.md), [unloadVocab](u/unloadVocab.md)

## Access Control {#funcs_by_topics_acl}

[getGroupAccess](g/getGroupAccess.md), [getGroupsByUserId](g/getGroupsByUserId.md), [getUserAccess](g/getUserAccess.md), [getUserList](g/getUserList.md), [getUsersByGroupId](g/getUsersByGroupId.md), [resetPwd](r/resetPwd.md), [changePwd](c/changePwd.md), [login](l/login.md), [logout](l/logout.md), [isLoggedIn](i/isLoggedIn.md), [createGroup](c/createGroup.md), [deleteGroup](d/deleteGroup.md), [createUser](c/createUser.md), [deleteUser](d/deleteUser.md), [addGroupMember](a/addGroupMember.md), [deleteGroupMember](d/deleteGroupMember.md), [deny](d/deny.md), [grant](g/grant.md), [revoke](r/revoke.md), [addAccessControl](a/addAccessControl.md), [getGroupAccess](g/getGroupAccess.md), [getGroupsByUserId](g/getGroupsByUserId.md), [getUserAccess](g/getUserAccess.md), [getUserList](g/getUserList.md), [getUserLockedStatus](g/getUserLockedStatus.md), [getUsersByGroupId](g/getUsersByGroupId.md), [getUserPasswordStatus](g/getUserPasswordStatus.md), [getAuthenticatedUsers](g/getAuthenticatedUsers.md), [getGroupList](g/getGroupList.md), [backupSettings](b/backupSettings.md), [lockUser](l/lockUser.md), [restoreSettings](r/restoreSettings.md), [oauthLogin](o/oauthLogin.md), [scramClientFinal](s/scramClientFinal.md), [scramClientFirst](s/scramClientFirst.md), [unlockUser](u/unlockUser.md)

## File System {#funcs_by_topics_filesystem}

[file](f/file.md), [files](f/files.md), [fflush](f/fflush.md), [mkdir](m/mkdir.md), [rm](r/rm.md), [rmdir](r/rmdir.md), [close](c/close.md), [cleanOutdateLogFiles](c/cleanOutdateLogFiles.md), [exists](e/exists.md), [seek](s/seek.md), [read!](r/read!.md), [readBytes](r/readBytes.md), [readLine](r/readLine.md), [readLines](r/readLines.md), [readLines!](r/readLines!.md), [readObject](r/readObject.md), [readRecord!](r/readRecord!.md), [write](w/write.md), [writeBytes](w/writeBytes.md), [writeLine](w/writeLine.md), [writeLines](w/writeLines.md), [writeRecord](w/writeRecord.md), [saveText](s/saveText.md), [saveTextFile](s/saveTextFile.md), [saveAsNpy](s/saveAsNpy.md), [writeLog](w/writeLog.md), [writeLogLevel](w/writeLogLevel.md), [writeObject](w/writeObject.md), [loadModel](l/loadModel.md), [saveModel](s/saveModel.md)

## System Management {#funcs_by_topics_sys_mgt}

[getSupportBundle](g/getSupportBundle.md), [license](l/license.md), [version](v/version.md), [updateLicense](u/updateLicense.md), [getLicenseExpiration](g/getLicenseExpiration.md), [pipeline](p/pipeline.md), [setRandomSeed](s/setRandomSeed.md), [setRetentionPolicy](s/setRetentionPolicy.md), [setSystem](s/setSystem.md), [setLogLevel](s/setLogLevel.md), [syntax](s/syntax.md), [partial](p/partial.md), [defined](d/defined.md), [defs](d/defs.md), [undef](u/undef.md), [refCount](r/refCount.md), [member](m/member.md), [objs](o/objs.md), [objByName](o/objByName.md), [closeSessions](c/closeSessions.md), [getSessionMemoryStat](g/getSessionMemoryStat.md), [getCurrentSessionAndUser](g/getCurrentSessionAndUser.md), [loadPlugin](l/loadPlugin.md), [module](../Programming/ProgrammingStatements/module.md), [use](../Programming/ProgrammingStatements/use.md), [loadModule](l/loadModule.md), [saveModule](s/saveModule.md), [loadModuleFromScript](l/loadModuleFromScript.md), [listRemotePlugins](l/listRemotePlugins.md), [installPlugin](i/installPlugin.md), [timer](../Programming/ProgrammingStatements/timer.md), [evalTimer](e/evalTimer.md), [scheduleJob](s/scheduleJob.md), [submitJob](s/submitJob.md), [submitJobEx2](s/submitjobex2.md), [submitJobEx](s/submitJobEx.md), [cancelJob](c/cancelJob.md), [cancelConsoleJob](c/cancelConsoleJob.md), [deleteScheduledJob](d/deleteScheduledJob.md), [setMaxJobParallelism](s/setMaxJobParallelism.md), [setMaxJobPriority](s/setMaxJobPriority.md), [getConsoleJobs](g/getConsoleJobs.md), [getJobMessage](g/getJobMessage.md), [getJobReturn](g/getJobReturn.md), [getJobStat](g/getJobStat.md), [getJobStatus](g/getJobStatus.md), [getRecentJobs](g/getRecentJobs.md), [getScheduledJobs](g/getScheduledJobs.md), [getPerf](g/getPerf.md), [getClusterPerf](g/getClusterPerf.md), [getTSDBDataStat](g/getTSDBDataStat.md), [enableResourceTracking](e/enableresourcetracking.md), [disableResourceTracking](d/disableresourcetracking.md), [getUserHardwareUsage](g/getuserhardwareusage.md), [getUserTableAccessRecords](g/getusertableaccessrecords.md), [setDatanodeRestartInterval](s/setdatanoderestartinterval.md), [getDatanodeRestartInterval](g/getdatanoderestartinterval.md), [getDynamicConfig](g/getDynamicConfig.md), [setDynamicConfig](s/setDynamicConfig.md), [getTSDBTableIndexCacheStatus](g/getTSDBTableIndexCacheStatus.md), [SetMemLimitOfAllTempResults](s/setMemLimitOfAllTempResults.md), [getMemLimitOfAllTempResults](g/getMemLimitOfAllTempResults.md), [getLoadedPlugins](g/getLoadedPlugins.md), [startHeapSample](s/startHeapSample.md), [dumpHeapSample](d/dumpHeapSample.md), [stopHeapSample](s/stopHeapSample.md), [getAclAuditLog](g/getaclauditlog.md), [getAuditLog](g/getAuditLog.md)

## MCP {#topic_akt_k5t_4gc}

[addMCPPrompt](a/addMCPPrompt.md), [addMCPTool](a/addMCPTool.md), [callMCPTool](c/callMCPTool.md), [dropMCPPrompt](d/dropMCPPrompt.md), [dropMCPTool](d/dropMCPTool.md), [getMCPPrompt](g/getMCPPrompt.md), [listMCPPrompts](l/listMCPPrompts.md),[listMCPTools](l/listMCPTools.md), [publishMCPPrompts](p/publishMCPPrompts.md), [publishMCPTools](p/publishMCPTools.md), [updateMCPPrompt](u/updateMCPPrompt.md), [updateMCPTool](u/updateMCPTool.md), [withdrawMCPPrompts](w/withdrawMCPPrompts.md), [withdrawMCPTools](w/withdrawMCPTools.md)

## Environment {#funcs_by_topics_env}

[clearAllCache](c/clearAllCache.md), [clearCachedModules](c/clearCachedModules.md), [getDiskIOStat](g/getDiskIOStat.md), [getMemoryStat](g/getMemoryStat.md), [getEnv](g/getEnv.md), [getHomeDir](g/getHomeDir.md), [getOS](g/getOS.md), [getOSBit](g/getOSBit.md), [getSystemCpuUsage](g/getSystemCpuUsage.md), [getSystemLoadAvg](g/getSystemLoadAvg.md), [mem](m/mem.md), [moveHotDataToColdVolume](m/moveHotDataToColdVolume.md), [sleep](s/sleep.md), [shell](s/shell.md)

## Others {#funcs_by_topics_others}

[attributeNames](a/attributeNames.md), [attributeValues](a/attributeValues.md),[plot](p/plot.md), [plotHist](p/plotHist.md), [genericStateIterate](g/genericStateIterate.md), [genericTStateIterate](g/genericTStateIterate.md), [snippet](s/snippet.md), [hmac](h/hmac.md), [constantDesc](c/constantDesc.md)

