# fy5253 {#fy5253}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`fy5253(X, [weekday=0], [startingMonth=1], [nearest=true], [offset], [n=1])`

## Arguments {#arguments}

**X** is a scalar/vector. Its data type can be DATE, DATETIME, TIMESTAMP, or NANOTIMESTAMP.

**weekday** \(optional\) is an integer between 0 and 6. 0 means Monday, 1 means Tuesday, …, and 6 means Sunday. The default value is 0.

**startingMonth** \(optional\) is an integer between 1 and 12 indicating the beginning month of a year. The default value is 1.

**nearest** \(optional\) is a Boolean value. The default value is true.

**offset** \(optional\) is a scalar with the same data type as *X*. It must be no greater than the minimum value in *X*. The default value is the minimum value in *X*.

**n** \(optional\) is a positive integer.The default value is 1.

## Details {#details}

Using the 52-53 weeks in a fiscal year \(4-4-5 calendar\), it returns the start date of fiscal year which includes *X*.

-   If *nearest*=true, the last weekday which is closest to the last day of *startingMonth* will be used as the starting date of the fiscal year.

-   If *nearest*=false, the last weekday in *startingMonth* will be used as the starting date of the fiscal year.


If *offset* is specified, it means that starting from the *offset*, the result will be updated every *n* years. Note that *offset* can take effect only when *n* is greater than 1.

## Examples {#examples}

```
fy5253(2016.11.01,0,1,true);
// output: 2016.02.01 // The Monday closest to 2016.01.31 is 2016.02.01

fy5253(2016.11.01,0,1,false);
// output: 2016.01.25 // The last Monday in January 2016 is 2016.01.25

date=2011.10.25 2012.10.25 2013.10.25 2014.10.25 2015.10.25 2016.10.25 2017.10.25 2018.10.25 2019.10.25 2020.10.25
time = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12,09:38:13]
sym = take(`MSFT,10)
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29 52.38
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800 4500
t1 = table(date, time, sym, qty, price);

select avg(price),sum(qty) from t1 group by fy5253(date,0,1,true,2011.10.01,2);
```

|fy5253\_date|avg\_price|sum\_qty|
|------------|----------|--------|
|2011.01.31|39.53|4100|
|2013.01.28|29.77|5300|
|2015.02.02|175.1|12200|
|2017.01.30|50.54|3800|
|2019.01.28|51.835|13300|

Related function: [fy5253Quarter](fy5253Quarter.md)

