# fxSwapPricer {#fxSwapPricer}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`fxSwapPricer(instrument, pricingDate, spot, domesticCurve, foreignCurve)`

## Arguments {#arguments}

**instrument** is an INSTRUMENT scalar of FxSwap type indicating the foreign exchange swap to be priced.

**pricingDate** is a DATE scalar specifying the pricing date.

**spot** is a numeric scalar indicating the spot exchange rate.

**domesticCurve** A MKTDATA scalar representing the domestic discount curve.

**foreignCurve** A MKTDATA scalar representing the foreign discount curve.

## Details {#details}

Calculates the Net Present Value \(NPV\) of the foreign exchange swap.

**Return value**: A DOUBLE scalar.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
pricingDate = 2025.08.18

fxSwap = {
    "productType": "Swap",
    "swapType": "FxSwap",
    "version": 0,
    "currencyPair": "USDCNY",
    "direction": "Buy",
    "notional": ["USD", 1E6],
    "nearStrike": 7.15,
    "nearExpiry": pricingDate + 60,
    "nearDelivery": pricingDate + 62,
    "farStrike": 7.18,
    "farExpiry": pricingDate + 180,
    "farDelivery": pricingDate + 182
}

curveDates = [2025.08.21,
              2025.08.27,
              2025.09.03,
              2025.09.10,
              2025.09.22,
              2025.10.20,
              2025.11.20,
              2026.02.24,
              2026.05.20,
              2026.08.20,
              2027.02.22,
              2027.08.20,
              2028.08.21]
domesticCurveInfo = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "referenceDate": pricingDate,
    "currency": "CNY",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",  
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates": curveDates,
    "values":[1.5113, 
              1.5402, 
              1.5660, 
              1.5574, 
              1.5556, 
              1.5655, 
              1.5703, 
              1.5934, 
              1.6040, 
              1.6020, 
              1.5928, 
              1.5842, 
              1.6068]/100
}
foreignCurveInfo = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "referenceDate": pricingDate,
    "currency": "USD",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",  
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates": curveDates,
    "values":[4.3345, 
              4.3801, 
              4.3119, 
              4.3065, 
              4.2922, 
              4.2196, 
              4.1599, 
              4.0443, 
              4.0244, 
              3.9698, 
              3.7740, 
              3.6289, 
              3.5003]/100
}

instrument = parseInstrument(fxSwap)
domesticCurve = parseMktData(domesticCurveInfo)
foreignCurve = parseMktData(foreignCurveInfo)
spot = 7.1627

npv = fxSwapPricer(instrument, pricingDate, spot, domesticCurve, foreignCurve)
print(npv)
// output:84379.328782705269986
```

**Related functions:** [parseInstrument](../p/parseInstrument.md), [parseMktData](../p/parseMktData.md)

