# fxForwardPricer {#fxForwardPricer}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`fxForwardPricer(instrument, pricingDate, spot, domesticCurve, foreignCurve)`

## Details {#topic_awr_v5q_ngc}

Computes the Net Present Value \(NPV\) of an FX forward contract based on the given spot rate, domestic and foreign discount curves, and the pricing date.

**Return value**: A DOUBLE scalar.

## Arguments {#arguments}

**instrument** An INSTRUMENT object of type FxForward, representing the FX forward to be priced. See Product Field Specifications for details.

**pricingDate** A DATE scalar specifying the pricing date.

**spot** A DOUBLE scalar representing the spot exchange rate.

**domesticCurve** A MKTDATA object of type IrYieldCurve representing the domestic discount curve. See [Curve Field Specifications](#topic_apg_y5q_ngc) for details.

**foreignCurve** A MKTDATA object of type IrYieldCurve representing the foreign discount curve. See [Curve Field Specifications](#topic_apg_y5q_ngc) for details.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
pricingDate = 2025.08.18

fxForward = {
    "productType": "Forward",
    "forwardType": "FxForward",
    "version": 0,
    "expiry": 2025.12.16,
    "delivery": 2025.12.18,
    "currencyPair": "USDCNY",
    "direction": "Buy",
    "notional": ["USD", 1E6],
    "strike": 7.1
}

curveDates = [2025.08.21,
              2025.08.27,
              2025.09.03,
              2025.09.10,
              2025.09.22,
              2025.10.20,
              2025.11.20,
              2026.02.24,
              2026.05.20,
              2026.08.20,
              2027.02.22,
              2027.08.20,
              2028.08.21]
domesticCurveInfo = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "referenceDate": pricingDate,
    "currency": "CNY",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",  
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates": curveDates,
    "values":[1.5113, 
              1.5402, 
              1.5660, 
              1.5574, 
              1.5556, 
              1.5655, 
              1.5703, 
              1.5934, 
              1.6040, 
              1.6020, 
              1.5928, 
              1.5842, 
              1.6068]/100
}
foreignCurveInfo = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "referenceDate": pricingDate,
    "currency": "USD",
    "dayCountConvention": "Actual365",
    "compounding": "Continuous",  
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates": curveDates,
    "values":[4.3345, 
              4.3801, 
              4.3119, 
              4.3065, 
              4.2922, 
              4.2196, 
              4.1599, 
              4.0443, 
              4.0244, 
              3.9698, 
              3.7740, 
              3.6289, 
              3.5003]/100
}

instrument = parseInstrument(fxForward)

domesticCurve = parseMktData(domesticCurveInfo)
foreignCurve = parseMktData(foreignCurveInfo)
spot = 7.1627

npv = fxForwardPricer(instrument, pricingDate, spot, domesticCurve, foreignCurve)
print(npv)

// output: 1919.8118
```

**Related functions**: [parseInstrument](../p/parseInstrument.md), [parseMktData](../p/parseMktData.md)

## Product Field Specifications {#topic_fft_x5q_ngc}

<table id="table_dm3_3vq_ngc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

productType

</td><td>

STRING

</td><td>

Product name. It must be "Forward".

</td><td>

√

</td></tr><tr><td>

forwardType

</td><td>

STRING

</td><td>

Foreign exchange forward type. It must be "FxForward".

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

notional

</td><td>

ANY vector

</td><td>

Notional principal amount, e.g., \["USD", 1.0\]

</td><td>

√

</td></tr><tr><td>

instrumentId

</td><td>

STRING

</td><td>

InstrumentId ID

</td><td>

×

</td></tr><tr><td>

expiry

</td><td>

DATE

</td><td>

Value date

</td><td>

√

</td></tr><tr><td>

delivery

</td><td>

DATE

</td><td>

Settlement date

</td><td>

√

</td></tr><tr><td>

currencyPair

</td><td>

STRING

</td><td>

The currency pair, in the format "EURUSD", "EUR.USD", or "EUR/USD". Supported currency pairs include:

 -   "EURUSD": Euro to US Dollar

-   "USDCNY": US Dollar to Chinese Yuan

-   "EURCNY": Euro to Chinese Yuan

-   "GBPCNY": British Pound to Chinese Yuan

-   "JPYCNY": Japanese Yen to Chinese Yuan

-   "HKDCNY": Hong Kong Dollar to Chinese Yuan


</td><td>

√

</td></tr><tr><td>

direction

</td><td>

STRING

</td><td>

Trading direction, can be "Buy" or "Sell"

</td><td>

√

</td></tr><tr><td>

strike

</td><td>

DOUBLE

</td><td>

Strike price

</td><td>

√

</td></tr><tr><td>

domesticCurve

</td><td>

STRING

</td><td>

The domestic discount curve name

</td><td>

×

</td></tr><tr><td>

foreignCurve

</td><td>

STRING

</td><td>

The foreign discount curve name

</td><td>

×

</td></tr></tbody>
</table>## Curve Field Specifications {#topic_apg_y5q_ngc}

<table id="table_p1w_qk1_4gc"><thead><tr><th>

Field Name

</th><th>

Data Type

</th><th>

Description

</th><th>

Required

</th></tr></thead><tbody><tr><td>

mktDataType

</td><td>

STRING

</td><td>

Must be "Curve"

</td><td>

√

</td></tr><tr><td>

referenceDate

</td><td>

DATE

</td><td>

Reference Date

</td><td>

√

</td></tr><tr><td>

version

</td><td>

INT

</td><td>

Version, default 0

</td><td>

×

</td></tr><tr><td>

curveType

</td><td>

STRING

</td><td>

Must be "IrYieldCurve"

</td><td>

√

</td></tr><tr><td>

dayCountConvention

</td><td>

STRING

</td><td>

The day count convention to use. It can be:

 -   "Actual360": actual/360

-   "Actual365": actual/365

-   "ActualActualISMA": actual/actual according to ISMA \(International Securities Market Association\) convention

-   "ActualActualISDA": actual/actual according to ISDA \(International Swaps and Derivatives Association\) convention.


</td><td>

√

</td></tr><tr><td>

interpMethod

</td><td>

STRING

</td><td>

Interpolation method. It can be:

 -   "Linear": linear interpolation

-   "CubicSpline": cubic spline interpolation

-   "CubicHermiteSpline": cubic Hermite interpolation


</td><td>

√

</td></tr><tr><td>

extrapMethod

</td><td>

STRING

</td><td>

Extrapolation method. It can be

 -   Flat: flat extrapolation

-   Linear: linear extrapolation


</td><td>

√

</td></tr><tr><td>

dates

</td><td>

DATE vector

</td><td>

Date of each data point

</td><td>

√

</td></tr><tr><td>

values

</td><td>

DOUBLE vector

</td><td>

Value of each data point, corresponding to the elements in dates.

</td><td>

√

</td></tr><tr><td>

curveName

</td><td>

STRING

</td><td>

Curve name

</td><td>

×

</td></tr><tr><td>

currency

</td><td>

STRING

</td><td>

Currency. It can be CNY", "USD", "EUR", "GBP", "JPY", "HKD"

</td><td>

√

</td></tr><tr><td>

compounding

</td><td>

STRING

</td><td>

The compounding interest. It can be:

 -   "Compounded": discrete compounding

-   "Simple": simple interest \(no compounding\).

-   "Continuous": continuous compounding.


</td><td>

√

</td></tr><tr><td>

settlement

</td><td>

DATE

</td><td>

Settlement date. If specified, all subsequent tenor intervals are computed starting from "settlement" rather than from "referenceDate".

</td><td>

×

</td></tr><tr><td>

frequency

</td><td>

INTEGRAL/STRING

</td><td>

The interest payment frequency. Supported values:

 -   -1 or "NoFrequency": No payment frequency

-   0 or "Once": Single lump-sum payment of principal and interest at maturity.

-   1 or "Annual": Annually

-   2 or "Semiannual": Semiannually

-   3 or "EveryFourthMonth": Every four months

-   4 or "Quarterly": Quarterly

-   6 or "BiMonthly": Every two months

-   12 or "Monthly": Monthly

-   13 or "EveryFourthWeek": Every four weeks

-   26 or "BiWeekly": Every two weeks

-   52 or "Weekly": Weekly

-   365 or "Daily": Daily

-   999 or "Other": Other frequencies


</td><td>

×

</td></tr><tr><td>

curveModel

</td><td>

STRING

</td><td>

Curve construction model; Currently, only "Bootstrap" is supported.

</td><td>

×

</td></tr><tr><td>

curveParams

</td><td>

DICT

</td><td>

Model parameters.

</td><td>

×

</td></tr></tbody>
</table>