# funcByName {#funcbyname}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`funcByName(name)`

## Arguments {#arguments}

**name** is a string indicating an operator or a function. The function can be either a built-in function or a user-defined function.

## Details {#details}

Dynamically execute an operator or a function. It is mainly used in metaprogramming.

## Examples {#examples}

```
def f(x, a, b){
   return funcByName(x)(a, b)
}

f("+", 1 2 3, 4 5 6);
// output: [5,7,9]

f("sub", 1 8 3, 4 8 6);
// output: [-3,0,-3]

f("corr", 1 8 3, 4 8 6);
// output: 0.970725

def cal(a,b){
   return pow(a\b,2)
}

f("cal", 4 8 10, 2 2 2);
// output: [4,16,25]

funcByName("call")(sum,1..10);
// output: 55
```

