# fromStdJson {#fromStdJson}

## Syntax {#Syntax .section}

`fromStdJson(X)`

## Arguments {#Arguments .section}

**X** is a scalar or vector of standard JSON string\(s\).

## Details {#Details .section}

Convert *X* to a DolphinDB variable. The following table shows the data form/type mappings.

|JSON|DolphinDB|
|----|---------|
|object|Dictionary whose keys must be of STRING type, and values can be of ANY type if multiple types are converted.|
|array|vector|
|string|Convert to a Temporal value first. If fails, it convert to a UTF-8 string.|
|number|DOUBLE|
|boolean|BOOL|
|null|NULL|

Note: Escape sequences will be automatically interpreted during conversion.

## Examples {#Examples .section}

``` {#codeblock_glp_24w_nbc}
X = "[1, 2, 3]";
fromStdJson(X);
//output:[1,2,3]

X = "{\"1\": \"2017.07.10 14:10:12\",\"0\": \"2012.06.13 13:30:10\"}";
fromStdJson(X);
/* output:1->2017.07.10T14:10:12
      0->2012.06.13T13:30:10
*/
```



**Parent topic:**[Functions](../../Functions/category.md)

