# format {#format}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`format(X, format)`

## Arguments {#arguments}

**X** is a scalar/vector.

**format** is a string indicating the format to be applied to *X*. Depending on the data type of input *X*, *format* calls either function [decimalFormat](../d/decimalFormat.md) or [temporalFormat](../t/temporalFormat.md).

## Details {#details}

Apply a specified format to the given object.

**Return value**: a STRING scalar/vector.

## Examples {#examples}

```
t = table(1..100 as id, (1..100 + 2018.01.01) as date, rand(100.0, 100) as price, rand(10000, 100) as qty);
t;
```

|id|date|price|qty|
|---|----|-----|---|
|1|2018.01.02|70.832104|1719|
|2|2018.01.03|12.22557|6229|
|3|2018.01.04|8.695886|1656|
|4|2018.01.05|24.324535|2860|
|5|2018.01.06|0.443173|6874|
|6|2018.01.07|90.302176|3277|
|7|2018.01.08|78.556843|3424|
|8|2018.01.09|45.836447|8636|
|9|2018.01.10|57.416425|707|
|10|2018.01.11|98.879764|2267|
|...||||

```
select id, date.format("MM/dd/yyyy") as date, price.format("00.00") as price, qty.format("#,###") as qty from t;
```

|id|date|price|qty|
|---|----|-----|---|
|1|01/02/2018|70.83|1,719|
|2|01/03/2018|12.23|6,229|
|3|01/04/2018|08.70|1,656|
|4|01/05/2018|24.32|2,860|
|5|01/06/2018|00.44|6,874|
|6|01/07/2018|90.30|3,277|
|7|01/08/2018|78.56|3,424|
|8|01/09/2018|45.84|8,636|
|9|01/10/2018|57.42|707|
|10|01/11/2018|98.88|2,267|
|...||||

