# fmin {#fmin}

## Syntax {#Syntax .section}

`fmin(f, X0, [fargs], [xtol=0.0001], [ftol=0.0001], [maxIter], [maxFun])`

## Details {#Arguments .section}

Use a Nelder-Mead simplex algorithm to find the minimum of function of one or more variables. This algorithm only uses function values, not derivatives or second derivatives.

## Arguments {#Details .section}

**func** is the objective function to be minimized. The function must return a numeric scalar.

**X0** is a numeric scalar or vector indicating the initial guess.

**xtol** \(optional\) is a positive number specifying the absolute error in xopt between iterations that is acceptable for convergence. The default value is

**ftol** \(optional\) is a positive number specifying the absolute error in `func(xopt)` between iterations that is acceptable for convergence. The default value is 0.0001.

**maxIter** \(optional\) is a non-negative integer indicating the maximum number of iterations to perform.

**maxFun** \(optional\) is a non-negative integer indicating the maximum number of function evaluations to make.

It returns a dictionary with the following keys:

-   xopt: a vector of floating-point numbers, indicating parameter that minimizes function.

-   fopt: a floating-point number, indicating value of function at minimum: `fopt = f(xopt)`.

-   iterations: an integer, indicating number of iterations performed.

-   fcalls: an integer, indicating number of function calls made.

-   warnFlag: an integer that takes the following values

    -   0: Optimization algorithm completed.

    -   1: Maximum number of function evaluations made.

    -   2: Maximum number of iterations reached.


## Examples {#Examples .section}

In the following example, we define a function `f(x)` and use the Nelder-Mead simplex algorithm to find its minimum value.

``` {#codeblock_grg_flk_zbc}
def f(x) {return x*x}
fmin(f, 1)
/* Ouput:
xopt->[-8.881784197001252E-16]
fopt->7.888609052210119E-31
iterations->17
fcalls->34
warnFlag->0
*/
```

**Parent topic:**[Functions](../../Functions/category.md)

