# floor {#floor}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`floor(X)`

## Arguments {#arguments}

**X** is a scalar, vector, or matrix.

## Details {#details}

The `floor` and [ceil](../c/ceil.md) functions map a real number to the largest previous and the smallest following integer, respectively. Function [round](../r/round.md) maps a real number to the largest previous or the smallest following integer with the round half up rule.

## Examples {#examples}

```
floor(2.1);
// output: 2
floor(2.9);
// output: 2
floor(-2.1);
// output: -3

ceil(2.1);
// output: 3
ceil(2.9);
// output: 3
ceil(-2.1);
// output: -2

round(2.1);
// output: 2
round(2.9);
// output: 3
round(-2.1);
// output: -2
```

``` {#codeblock_mbd_5hs_hzb}
m = 1.1 2.2 3.3 4.4 5.5 6.6 7.7 8.8 9.9 10$2:5;
m;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1.1|3.3|5.5|7.7|9.9|
|2.2|4.4|6.6|8.8|10|

```
floor(m);
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1|3|5|7|9|
|2|4|6|8|10|

