# floatingRateBondDirtyPrice {#floatingratebonddirtyprice}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`floatingRateBondDirtyPrice(settlement, issue, maturity, redemption, spread, riskFree, calendar, frequency, [basis=1], [convention="Following"])`

## Details {#details}

Calculate the dirty price for each 100 face value of a floating rate bond.

The coupon rate of a floating rate bond is not fixed; it is periodically adjusted based on a reference rate \(such as LIBOR\). The actual interest rate of a floating rate bond is typically composed of the reference rate plus a fixed spread, which is determined at bond’s issuance and remains fixed until maturity.

**Return value:** A DOUBLE scalar or vector.

## Arguments {#arguments}

**Note:** Scalar inputs will be automatically expanded to match the length of other vector inputs. All vector inputs must be of equal length.

**settlement** is a DATE scalar or vector indicating the settlement date.

**issue** is a DATE scalar or vector indicating the bond's issuance date.

**maturity** is a DATE scalar or vector indicating the maturity date.

**redemption** is a numeric scalar or vector indicating the redemption value.

**spread** is a numeric scalar or vector indicating the interest rate spread.

**riskFree** is a numeric scalar or vector indicating the risk-free interest rate.

**calendar** is a STRING scalar or vector indicating the trading calendar\(s\). See [Trading Calendar](../../Tutorials/trading_calendar.md) for more information.

**frequency** is an INT scalar/vector indicating the number of payments, or a STRING scalar/vector indicating payment frequency. It can be:

-   0/"Once": Bullet payment at maturity.
-   1/"Annual": Annual payments.
-   2/"Semiannual": Semi-annual payments.
-   4/"Quarterly": Quarterly payments.
-   12/"Monthly": Monthly payments.

**basis** \(optional\) is an INT/STRING scalar or vector indicating the day count basis to use. It can be:

-   0/"Thirty360US": US \(NASD\) 30/360
-   1/"ActualActual": actual/actual
-   2/"Actual360": actual/360
-   3/"Actual365": actual/365
-   4/"Thirty360EU": European 30/360

**convention** \(optional\) is a STRING scalar or vector indicating how cash flows that fall on a non-trading day are treated. The following options are available. Defaults to 'Following'.

-   'Following': The following trading day.
-   'ModifiedFollowing': The following trading day. If that day is in a different month, the preceding trading day is adopted instead.
-   'Preceding': The preceding trading day.
-   'ModifiedPreceding': The preceding trading day. If that day is in a different month, the following trading day is adopted instead.
-   'Unadjusted': Unadjusted.
-   'HalfMonthModifiedFollowing': The following trading day. If that day crosses the mid-month \(15th\) or the end of month, the preceding trading day is adopted instead.
-   'Nearest': The nearest trading day. If both the preceding and following trading days are equally far away, default to following trading day.

## Examples {#examples}

Calculate the price for a bond issued on June 9, 2020, with a maturity date of June 9, 2025, a trading date of September 15, 2020, an market risk-free rate of 0.0385, a bond spread of -0.0075, quarterly interest payments, and an actual/actual day count basis. The trading calendar is NewYork Stock Exchange \(XNYS\), with no adjustment for non-business days.

``` {#codeblock_zq1_tms_c2c}
floatingRateBondDirtyPrice(settlement=2020.09.15, issue=2020.06.09, maturity=2025.06.09, redemption=100.0, spread=-0.0075, riskFree=0.0385, calendar=`XNYS, frequency=3M,convention=`Unadjusted)
// output: 96.8209
```

