# firstNot {#firstnot}

## Syntax {#syntax}

`firstNot(X, [k])`

## Arguments {#arguments}

**X** can be a scalar, pair, vector, matrix or table.

**k** \(optional\) is a scalar.

## Details {#details}

If *X* is a vector:

-   If *k* is not specified: return the first element of *X* that is not null.

-   If *k* is specified: return the first element of *X* that is neither *k* nor null.


If *X* is a matrix or table, conduct the aforementioned calculation within each column of *X*. The result is a vector.

## Examples {#examples}

```
firstNot(0 0 0 6 1, 0);
// output: 6

firstNot(NULL 0 3 2 1, 0);
// output: 3

firstNot(NULL 0 1 6);
// output: 0

t=table(1 1 1 1 1 2 2 2 2 2 as id, 0 0 0 2 1 NULL NULL 0 0 3 as x);
t;
```

|id|x|
|---|---|
|1|0|
|1|0|
|1|0|
|1|2|
|1|1|
|2||
|2||
|2|0|
|2|0|
|2|3|

```
select firstNot(x, 0) from t group by id;
```

|id|firstNot\_x|
|---|-----------|
|1|2|
|2|3|

```
m=matrix(0 NULL 1 2 3, NULL 2 NULL 0 3);
m;
```

|\#0|\#1|
|---|---|
|0|2|
|1||
|2|0|
|3|3|

```
firstNot(m, 0);
// output: [1,2]
```

