# firstHit {#firsthit}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`firstHit(func, X, target)`

## Arguments {#arguments}

**func** can only be the following operators: &gt;, &gt;=, &lt;, &lt;=, !=, &lt;&gt;, ==.

**X** is a vector/matrix/table.

**target** is a scalar of the same type as *X* indicating the value to be compared with *X*.

## Details {#details}

Return the first element in *X* that satisfies the condition `X func target` \(e.g. X&gt;5\). If no element in *X* satisfies the condition, return a NULL vlaue.

Null values are ignored in `firstHit`. Use [firstNot](firstNot.md) to find the first non-null value.

## Examples {#examples}

```
X = NULL 3.2 4.5 1.2 NULL 7.8 0.6 9.1
firstHit(<, X, 2.5)
// output: 1.2

// return null value if no element satisfies the condition
firstHit(>, X, 10.0)
// output: NULL
```

Related Function: [ifirstHit](../i/ifirstHit.md)

