# find {#find}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`find(X, Y)`

## Arguments {#arguments}

**X** can be a vector, dictionary, in-memory table with one column, keyed table, or indexed table.

**Y** can be a scalar, vector, matrix, tuple, dictionary, or table.

## Details {#details}

-   If *X* is a vector: for each element of *Y*, return the position of its first occurrence in vector X. If the element doesn't appear in X, return -1. \(To find the positions of all occurences, please use function [at](../a/at.md).\)
-   If *X* is a dictionary: for each element of *Y*, if it is a key in *X*, return the corresponding value in *X*; if it is not a key in *X*, return NULL.
-   If *X* is an in-memory table with one column: for each element of *Y*, return the position of its first occurrence in the column of *X*. If the element doesn't appear in *X*, return -1.Note the column cannot be of array vector form.
-   If *X* is a keyed table or indexed table: for each element of *Y*, return the position of its first occurrence in the key columns of *X*. If the element doesn't appear in the key columns of *X*, return -1.

To search for a small amount of data in a sorted vector, we recommend to use function [binsrch](../b/binsrch.md).

## Examples {#examples}

When *X* is a vector:

```
find(7 3 3 5, 3);
// output
1

at(7 3 3 5 == 3);
// output
[1,2]

(7 3 3 5 6).find(2 4 5);
// output
[-1,-1,3]
```

When *X* is a dictionary:

```
z=dict(1 2 3,4.5 6.6 3.2);
z;
// output
3->3.2
1->4.5
2->6.6

find(z,3);
// output
3.2
find(z,5);
// output
00F
```

When *X* is an in-memory table with one column:

```
t = table(1 3 5 7 9 as id)
find(t, 2 3)
// output
[-1,1]
```

When *X* is a keyed table or an indexed table:

```
kt = keyedTable(`name`id,1000:0,`name`id`age`department,[STRING,INT,INT,STRING])
insert into kt values(`Tom`Sam`Cindy`Emma`Nick, 1 2 3 4 5, 30 35 32 25 30, `IT`Finance`HR`HR`IT)
find(kt,(`Emma`Sam, 4 1));
// output
[3,-1]

t1 = indexedTable(`sym`side, 10000:0, `sym`side`price`qty, [SYMBOL,CHAR,DOUBLE,INT])
insert into t1 values(`IBM`MSFT`GOOG, ['B','S','B'], 10.01 10.02 10.03, 10 10 20)
find(t1, (`GOOG`MSFT, ['B','S']))
// output
[2,1]
```

