# files {#files}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`files(directory, [pattern])`

## Arguments {#arguments}

**directory** is a string indicating a directory path.

**pattern** \(optional\) is a string indicating the file name pattern to be searched under the directory.

## Details {#details}

It must be executed by a logged-in user.

If *pattern* is not specified, return a table with descriptive information of the files and the sub-directories under directory.

If *pattern* is specified, return a table with descriptive information of the files and sub-directories that contain pattern in their names.

## Examples {#examples}

```
files("D:/06_DolphinDB/01_App/DolphinDB_Win_V0.2");
```

|filename|isDir|fileSize|lastAccessed|lastModified|
|--------|-----|--------|------------|------------|
|LICENSE\_AND\_AGREEMENT.txt|0|22558|1495508675000|1483773234998|
|README\_WIN.txt|0|5104|1495508675000|1483866232680|
|server|1|0|1496624932437|1496624932437|
|THIRD\_PARTY\_SOFTWARE\_LICENS...|0|8435|1495508675000|1483628426506|

```
files("D:/06_DolphinDB/01_App/DolphinDB_Win_V0.2", "readme%");
```

|filename|isDir|fileSize|lastAccessed|lastModified|
|--------|-----|--------|------------|------------|
|README\_WIN.txt|0|5104|1495508675000|1483866232680|

```
select * from files("D:/06_DolphinDB/01_App/DolphinDB_Win_V0.2") where filename like "README%";
```

|filename|isDir|fileSize|lastAccessed|lastModified|
|--------|-----|--------|------------|------------|
|README\_WIN.txt|0|5104|1495508675000|1483866232680|

