# fflush {#fflush}

## Syntax {#syntax}

`fflush(obj)`

## Arguments {#arguments}

**obj** is a file handle. Open a file with function [file](file.md) to obtain the file handle.

## Details {#details}

Write the buffered data to the file system in the operating system. It must be executed by a logged-in user.

Note:

1.  It is recommended to `close` the file or `fflush` the buffered data to the file after writing to it, otherwise the data may be lost.

2.  This command does not synchronize data to the disk. Data loss may occur in case of unexpected crash.


## Examples {#examples}

```
rows = 10
t=table(1..rows as id, 1..rows+100 as value)
f1=file("test.bin", "w")
f1.writeRecord(t)
//The file was not closed and the buffered data was not flushed to the file system, so the file read here does not contain the newly written data.
t1 = table(rows:0,`id`value,`INT`INT)
f=file('test.bin')
f.readRecord!(t1)
::readRecord!(f, t1) => Reach the end of a file or a buffer.

//call fflush
f1.fflush()

t1 = table(rows:0,`id`value,`INT`INT)
f=file('test.bin')
f.readRecord!(t1)
10
```

