# fTest {#ftest}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`fTest(X, Y, [ratio=1.0], [confLevel=0.95])`

## Arguments {#arguments}

**X** is a numeric vector indicating the first sample for the F-test.

**Y** is a numeric vector indicating the second sample for the F-test.

**ratio** \(optional\) is a positive floating number indicating the ratio of the variances of *X* and *Y* in the null hypothesis. The default value is 1.

**confLevel** \(optional\) is a floating number between 0 and 1 indicating the confidence level of the test. It is optional and the default value is 0.95.

## Details {#details}

Conduct an F-test to compare the variances of two samples.

Return a dictionary with the following keys:

-   stat: a table with p-value and confidence interval under 3 alternative hypotheses

-   numeratorDf: degree of freedom of the numerator

-   denominatorDf: degree of freedom of the denominator

-   confLevel: confidence level

-   method: "F test to compare two variances"

-   fValue: F-stat


## Examples {#examples}

```
x = norm(10.0, 1.0, 20);
y = norm(1.0, 2.0, 10);
fTest(x, y, 0.5);

/* output
numeratorDf->19
stat->
alternativeHypothesis                  pValue    lowerBound upperBound
-------------------------------------- --------- ---------- ----------
ratio of variances is not equal to 0.5 0.002326  0.025844   0.274161
ratio of variances is less than 0.5    0.001163  0          0.230624
ratio of variances is greater than 0.5 0.998837  0.032295   Infinity

denominatorDf->9
confLevel->0.95
fValue->0.190386
method->F test to compare two variances
*/
```

