# extractInstrument {#extractInstrument}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`extractInstrument(instrument)`

## Arguments {#arguments}

**instrument** is an INSTRUMENT scalar or a tuple of INSTRUMENT scalars.

## Details {#details}

Extract the data within the INSTRUMENT object\(s\).

**Return value:**

-   Returns a dictionary if the *instrument* is a scalar.

-   Returns a tuple of dictionaries if the *instrument* is a tuple.


## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
fxFwd1 = {
    "productType": "Forward",
    "forwardType": "FxForward",
    "version": 0,
    "expiry": 2025.10.08,
    "delivery": 2025.10.10,
    "currencyPair": "USDCNY",
    "direction": "Buy",
    "notional": ["USD", 1E6],
    "strike": 7.2
}
fxFwdUsdCny = parseInstrument(fxFwd1)
fxFwd2 = {
    "productType": "Forward",
    "forwardType": "FxForward",
    "version": 0,
    "expiry": 2025.10.08,
    "delivery": 2025.10.10,
    "currencyPair": "EURCNY",
    "direction": "Buy",
    "notional": ["EUR", 1E6],
    "strike": 8.2
}
fxFwdEurCny = parseInstrument(fxFwd2)

print extractInstrument([fxFwdUsdCny, fxFwdEurCny])

/* output
(productType->Forward
forwardType->FxForward
version->0
instrumentId->
expiry->2025.10.08
delivery->2025.10.10
currencyPair->USDCNY
direction->Buy
notional->("USD",1000000)
strike->7.200000000000001
domesticCurve->
foreignCurve->
,productType->Forward
forwardType->FxForward
version->0
instrumentId->
expiry->2025.10.08
delivery->2025.10.10
currencyPair->EURCNY
direction->Buy
notional->("EUR",1000000)
strike->8.199999999999999
domesticCurve->
foreignCurve->
)
*/
```

**Related function:** [parseInstrument](../p/parseInstrument.md)

