# expr {#expr}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`expr(args...)`

## Arguments {#arguments}

**args...** are objects, operators, or metacode. A metacode block contains objects or expressions enclosed by angle brackets &lt; &gt;. The minimum number of arguments is 2.

## Details {#details}

Generate metacode from *args*.

## Examples {#examples}

```
expr(6,<,8);
// output: < 6 < 8 >

expr(sum, 1 2 3);
// output: < sum [1,2,3] >

a=6;
expr(a,+,1);
// output: < 6 + 1 >

expr(<a>,+,1);
// output: < a + 1 >

expr(<a>,+,<b>);
// output: < a + b >

expr(a+7,*,8);
// output: < 13 * 8 >

expr(<a+7>,*,8);
// output: < (a + 7) * 8 >

expr(not, < a >);
// output: < ! a >
```

