# existsPartition {#existspartition}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`existsPartition(path, [tableName])`

## Arguments {#arguments}

**path** is a string indicating the path of a partition folder.

**tableName** \(optional\) is a string indicating the table name. If *chunkGranularity* is set to "DATABASE" when creating the database, *tableName* is not required. If *chunkGranularity* is set to "TABLE":

-   If the parameter path contains the physical index of the table \(which can be retrieved with the function `listTables`\), *tableName* is not required.

-   Otherwise, *tableName* must be specified.


## Details {#details}

Check if the specified partition exists.

## Examples {#examples}

Check if the specified partition exists. The following scripts must be executed on a data node or compute node.

```
n=1000000
ID=rand(10, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t=table(ID, date, x)

db = database("dfs://valueDB", VALUE, 2017.08.07..2017.08.11)
pt = db.createPartitionedTable(t, `pt, `date);
pt.append!(t);

listTables("dfs://valueDB")
```

|tableName|physicalIndex|
|---------|-------------|
|pt|s|

```
existsPartition("dfs://valueDB/20170807/s");
// output: true

//When the chunk granularity of the database is at TABLE level and the parameter path doesn't contain table physicalIndex, the parameter tableName must be specified or the partition cannot be found.
existsPartition("dfs://valueDB/20170807", `pt)
// output: true

existsPartition("dfs://valueDB/20170807");
// output: false

existsPartition("dfs://valueDB");
// output: false

existsPartition("dfs://valueDB/20170807/s/pt");
// output: false
```

