# exists {#exists}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`exists(path)`

## Arguments {#arguments}

**path** is a STRING scalar/vector, indicating the path of file\(s\) or folder\(s\).

## Details {#details}

Check if the specified file\(s\) or folder\(s\) exist. It can be used in the distributed files system to check if the specified folder\(s\) exist.

## Examples {#examples}

```
t=table(1..10 as ID, rand(1.0, 10) as x);
saveText(t, "C:/DolphinDB/Data/t.txt");

exists("C:/DolphinDB/Data/t.txt");
// output: true
exists("C:/DolphinDB/Data/t1.txt");
// output: false
exists("C:/DolphinDB/Data");
// output: true

exists(["C:/DolphinDB/Data/t.txt","C:/DolphinDB/Data/t1.txt","C:/DolphinDB/Data"]);
// output: [true,false,true]
```

To check if a folder \(or folders\) exists in the distributed files system \(the following script must be executed at a data node in a cluster\):

```
n=1000
ID=rand(10, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t=table(ID, date, x)

db = database("dfs://valueDB", VALUE, 2017.08.07..2017.08.11)
pt = db.createPartitionedTable(t, `pt, `date);
pt.append!(t);

exists("dfs://valueDB/20170807");
// output: true
```

