# evalTimer {#evaltimer}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`evalTimer(funcs, [count=1])`

## Arguments {#arguments}

**funcs** is a function or a tuple of functions with no parameters.

**count** \(optional\) is a positive number indicating the number of times funcs will be executed. The default value is 1.

## Details {#details}

Return the execution time of the specified functions in units of milliseconds. If *funcs* is a tuple of functions, return the amount of time to execute these functions consecutively.

The difference between statement [timer](../../Programming/ProgrammingStatements/timer.md) and function `evalTimer`:

-   the input of `timer` is a statement block while the input of `evalTimer` can only be functions. To use `evalTimer` to get execution time of a statement block, we need to rewrite the statement block as a user-defined function.

-   `timer` returns a message which cannot be assigned to a variable; `evalTimer` returns a scalar that can be assigned to a variable.


## Examples {#examples}

```
x=rand(10.0, 1000000)
evalTimer(dot{x,2},10);
// output: 39.609375

evalTimer(sort{x},10);
// output: 837.542702

evalTimer([dot{x,2},sort{x}],10)
// output: 870.065348
```

