# erase! {#erase}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`erase!(obj, key|filter)`

## Arguments {#arguments}

**obj** is a set/dictionary/table.

**key** \| **filter** is the elements to be deleted for a set; the keys of the members to be deleted for a dictionary; a piece of meta code with filtering conditions for a table. For details about meta code, please refer to [Metaprogramming](../../Programming/Metaprogramming/functional_meta.md).

## Details {#details}

Eliminate elements from a set, or members from a dictionary, or rows from a table.

## Examples {#examples}

On a set:

```
y=set(8 9 4 6);
y;
// output: set(6,4,9,8)
y.erase!(6);
// output: set(4,9,8)
erase!(y, 9 8);
// output: set(4)
```

On a dictionary:

```
x=1..6;
y=11..16;
z=dict(x,y);
z;
/* output
6->16
5->15
4->14
3->13
2->12
1->11
*/

erase!(z, 1..4);
/* output
6->16
5->15
*/
```

On a table:

```
x=1..10;
y=11..20;
t=table(x,y);

erase!(t, <x<=3>);
```

|x|y|
|---|---|
|4|14|
|5|15|
|6|16|
|7|17|
|8|18|
|9|19|
|10|20|

```
erase!(t, <x<=9 and y>=15>);
```

|x|y|
|---|---|
|4|14|
|10|20|

