# enlist {#enlist}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`enlist()`

## Arguments {#arguments}

**X** can be of any data form.

## Details {#details}

If *X* is a scalar, returns a vector.

If *X* is a dictionary:

-   When the keys are strings, it returns a single-row table.

-   When the keys are non-strings, it returns a tuple.


If *X* is a vector, tuple or of other data forms, returns a tuple.

## Examples {#examples}

```
enlist(1)
// output: [1]

enlist(`aaa)
// output: ["aaa"]

enlist([2022.01.01,2022.01.02,2022.01.03])
// output: ([2022.01.01,2022.01.02,2022.01.03])

enlist(["a",2,3])
// output: (("a",2,3))

a = array(INT[], 0, 10).append!([1 2 3, 4 5,6 7 8, 9 NULL])
enlist(a)
// output: ([[1,2,3],[4,5],[6,7,8],[9,00i]])

d1=dict(`a`b`c, (1, 2 3, 4))
enlist(d1)
```

|c|b|a|
|---|---|---|
|4|\[2, 3\]|1|

``` {#codeblock_vvl_212_ngc}
value =(-2 2 3, 0 1, 2.2 -3 1)
d2 = dict(1 2 3, value, true)
print enlist(d2)

/* output;
(1->[-2,2,3]
2->[0,1]
3->[2.2,-3,1]
)
*/
```

