# encodeShortGenomeSeq {#encodeshortgenomeseq}

## Syntax {#section_i3q_kxf_dzb .section}

`encodeShortGenomeSeq(X)`

Alias: encodeSGS

## Arguments {#section_qym_lxf_dzb .section}

`X` is a scalar/vector of STRING/CHAR type.

## Details {#section_pkc_mxf_dzb .section}

`encodeShortGenomeSeq` encodes DNA sequences made up of A, T, C, G letters. The encoding can reduce the storage space needed for DNA sequences and improve performance.

**Note:**

-   When *X* is an empty string \(""\), the function returns 0.

-   When *X* contains any character other than A, T, C, G \(case-sensitive\), the function returns NULL.

-   When the length of *X* exceeds 28 characters, the function returns NULL.


**Return Value**: LONG or FAST LONG vector

## Examples {#section_psx_4xf_dzb .section}

``` {#codeblock_orw_pxf_dzb}
a=encodeShortGenomeSeq("TCGATCG")
a;
// output: 465691
typestr(a)
// output: LONG

b=encodeShortGenomeSeq("TCGATCG" "TCGATCGCCC")
// output: [465691,168216298]
typestr(b)
// output: FAST LONG VECTOR

//NULL is returned as the input exceeds 28 characters after "TCGATCG" is repeated 5 times.
encodeShortGenomeSeq(repeat("TCGATCG" "TCGAT", 5))
// output: [,1801916404867712433]

y=toCharArray("TCGATCGCCC")
encodeShortGenomeSeq(y)
// output: 168216298

//NULL is returned in the following cases
encodeShortGenomeSeq("TC G")
encodeShortGenomeSeq("TCtG")
encodeShortGenomeSeq("NNNNNNNNTCGGGGCAT")
encodeShortGenomeSeq("TCGGGGCATNGCCCG")
encodeShortGenomeSeq("GCCCGATNNNNN")
```

Related functions: [decodeShortGenomeSeq](../d/decodeShortGenomeSeq.md), [genShortGenomeSeq](../g/genShortGenomeSeq.md)

**Parent topic:**[Functions](../../Functions/category.md)

