# duration {#duration}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`duration(X)`

## Arguments {#arguments}

**X** is a STRING scalar. It is composed of an integer and a unit of time \(y, M, w, d, B, H, m, s, ms, us, ns\). For examples: "2y", "3M", "30m", "100ms".

**X** is a STRING scalar composed of an integer and a unit of time. It supports the following units of time: y, M, w, d, B, H, m, s, ms, us, ns, and trading calendar identifier consisting of four capital letters. For example, *X* can be "2y", "3M", "30m", "100ms", and "3XNYS". Note that function `duration` won't verify whether the trading calendar file is stored in *marketHolidayDir*.

## Details {#details}

Convert *X* to DURATION type which indicates the length of a time interval.

Note:

-   The unit of the time interval used for grouping cannot be more granular than the unit of the temporal column.

-   Time units are case-sensitive, for example, "M" means month and "m" means minute. If the unit of the time interval is M, use function [month](../m/month.md) to convert the time column values to months.

-   Data of DURATION type cannot participate in calculations. For example, comparisons between DURATION values \(such as `duration(`20ms\) &gt;= duration\(`10ms)`\) are not supported.


## Examples {#examples}

```
y=duration("20H")
y
// output: 20H

typestr(y)
// output: DURATION

duration\("3XNYS"\)
// output: 3XNYS
```

In function bar, we can use a number followed by a time unit to indicate a duration.

```
t=table(take(2018.01.01T01:00:00+1..10,10) join take(2018.01.01T02:00:00+1..10,10) join take(2018.01.01T08:00:00+1..10,10) as time, rand(1.0, 30) as x)
select max(x) from t group by bar(time, 5);
```

|bar\_time|max\_x|
|---------|------|
|2018.01.01T01:00:00|0.8824|
|2018.01.01T01:00:05|0.8027|
|2018.01.01T01:00:10|0.572|
|2018.01.01T02:00:00|0.8875|
|2018.01.01T02:00:05|0.8542|
|2018.01.01T02:00:10|0.4287|
|2018.01.01T08:00:00|0.9294|
|2018.01.01T08:00:05|0.9804|
|2018.01.01T08:00:10|0.2147|

```
select max(x) from t group by bar(time, 1m);
```

|bar\_time|max\_x|
|---------|------|
|2018.01.01T01:00:00|0.8824|
|2018.01.01T02:00:00|0.8875|
|2018.01.01T08:00:00|0.9804|

Related information: [Trading Calendar](../../Tutorials/trading_calendar.md)

