# dropna {#dropna}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`dropna(X, [byRow=true], [thresh])`

## Arguments {#arguments}

**X** is a vector or matrix.

**byRow** \(optional\) is a Boolean value. The default value is true.

**thresh** \(optional\) is a positive integer.

## Details {#details}

If *X* is a vector, delete all null values from *X*.

If *X* is a matrix and *byRow*=true, delete all rows with null values.

If *X* is a matrix and *byRow*=false, delete all columns with null values.

If *thresh* is specified, each row or column \(as specified by *byRow*\) in the result must have at least *thresh* non-null values.

## Examples {#examples}

```
x=1 NULL 2 3 NULL NULL 4;
x.dropna();
// output: [1,2,3,4]

m=matrix(1 1 1 1, 1 1 1 NULL, 1 NULL 1 NULL);
m;
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|1|
|1|1||
|1|1|1|
|1|||

```
dropna(m);
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|1|
|1|1|1|

```
dropna(m,,2);
```

|\#0|\#1|\#2|
|---|---|---|
|1|1|1|
|1|1||
|1|1|1|

```
dropna(m,false);
```

|\#0|
|---|
|1|
|1|
|1|
|1|

```
dropna(m,false,3);
```

|\#0|\#1|
|---|---|
|1|1|
|1|1|
|1|1|
|1||

