# dropStreamGraph {#dropStreamGraph}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`dropStreamGraph(name, [includeTables])`

## Arguments {#arguments}

**name** is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "trading.orca\_graph.factors", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

**includesTables** \(optional\) is a Boolean value, indicating whether to delete user-created stream tables \(e.g., source, sink\) associated with the stream graph when deleting the graph. The default value is false.

## Details {#details}

Destroys the specified stream graph. After successful execution, the stream graph’s status is set to "destroyed", but the metadata record is not deleted.

-   If *includesTables*=true, the specified stream graph and its user-created stream tables will be deleted. Ensure that these stream tables are not referenced by other stream graphs; use `getStreamTableMeta` to check table references.
-   If false, only the stream graph itself will be deleted, leaving the associated stream tables intact.

In a cluster deployment, this function can only be executed by an administrator or a user who has the COMPUTE\_GROUP\_EXEC permission for the compute group that was used to create the stream graph. In a single-node deployment, permission checks are not required.

## Examples {#examples}

Create a stream graph named “indicators”.

``` {#codeblock_i2f_hfv_mgc}
dropStreamGraph("demo.orca_graph.indicators")

getStreamGraphMeta("demo.orca_graph.indicators")["status"]
// Output: ["destroyed"]
```

**Related functions:** [createStreamGraph](../c/createStreamGraph.md), [StreamGraph::dropGraph](../s/StreamGraph_dropGraph.md)

