# dropOrcaStreamTable {#dropOrcaStreamTable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`dropOrcaStreamTable(name)`

## Details {#topic_shq_tvd_ngc}

Deletes an Orca stream table.

The table can only be deleted if it is no longer referenced by any stream graph. You can use `getOrcaStreamTableMeta` to check its references.

## Arguments {#arguments}

**name** is a string representing the name of the Orca stream table. You can provide either the fully qualified name \(FQN\), such as "trading.orca\_table.factors", or just the table name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
// Create an Orca stream table
if(!existsCatalog("demo")){
    createCatalog("demo")
}
go
use catalog demo

createOrcaStreamTable("trade", `time`symbol`price`volume, [DATETIME,SYMBOL,DOUBLE,LONG])

// Delete the Orca stream table
dropOrcaStreamTable("demo.orca_table.trade")
// or dropOrcaStreamTable("trade")
```

