# dropDatabase {#dropdatabase}

## Syntax {#syntax}

`dropDatabase(dbDir)`

## Arguments {#arguments}

**dbDir** specifies the directory where the database is located. For a database in the distributed file system, the directory should start with "dfs://".

## Details {#details}

Delete all physical files from the specified database.

## Examples {#examples}

Drop a DFS database:

```
n=1000000
ID=rand(10, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t=table(ID, date, x);
saveText(t, "C:/DolphinDB/Data/t.txt");

db = database("dfs://valueDB", VALUE, 2017.08.07..2017.08.11)
pt = loadTextEx(db, `pt1, `date, "C:/DolphinDB/Data/t.txt");

dropDatabase("dfs://valueDB")
```

Drop a database on disk:

```
n=1000000
ID=rand(10, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t=table(ID, date, x)
saveText(t, "C:/DolphinDB/Data/t.txt");

db = database("C:/DolphinDB/Data/rangedb", RANGE, 0 5 10)
pt = loadTextEx(db, `pt, `ID, "C:/DolphinDB/Data/t.txt");

dropDatabase("C:/DolphinDB/Data/rangedb");
```

