# dot {#dot}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`dot(X, Y)`

or

`X**Y`

## Arguments {#arguments}

**X** / **Y** can be a scalar/vector/matrix. If both of *X* and *Y* are vectors, they must have the same length. If one of *X* and *Y* is a matrix, the other is a vector/matrix and their dimensions must satisfy the rules of matrix multiplication.

## Details {#details}

Return the matrix multiplication of *X* and *Y*. If *X* and *Y* are vectors of the same length, return their inner product.

## Examples {#examples}

```
x=1..6$2:3;
y=1 2 3;
x dot y;
```

|\#0|
|---|
|22|
|28|

```
x=1..6$2:3;
y=6..1$3:2;
x**y;
```

|\#0|\#1|
|---|---|
|41|14|
|56|20|

```
y**x;
```

|\#0|\#1|\#2|
|---|---|---|
|12|30|48|
|9|23|37|
|6|16|26|

```
a=1 2 3;
shape a;
// output: 3:1

x**a;
```

|\#0|
|---|
|22|
|28|

```
b=1 2;
shape b;
// output: 2:1

b**x;  // for a matrix multiplication between a matrix and a vector, the system may rotate the dimension of the vector for the multiplication to go through.
```

|\#0|\#1|\#2|
|---|---|---|
|5|11|17|

```
x=1 2 3;
y=4 5 6;
x ** y;
// output: 32  // inner product of two vectors. Equivalent to 1*4 + 2*5 + 3*6

x ** 2;
// output: [2,4,6]

x=1..6$2:3
x ** 2;
Error: Use * rather than ** for scalar and matrix multiplication.
```

