# div {#div}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`div(X, Y)`

or

`X/Y`

## Arguments {#arguments}

**X** and **Y** can be a scalar/pair/vector/matrix. If *X* or *Y* is a pair/vector/matrix, the other is a scalar or a pair/vector/matrix of the same size.

## Details {#details}

Return element-by-element division of *X* by *Y*.

When *X* or *Y* is floating, it returns a floating value.

When both *X* and *Y* are integers, `div` means integer division, which is the same as applying the [floor](../f/floor.md) function after division. For example, 5/2 is 2. If you want "true" division for integers, you can apply the operator [ratio\(\\\)](../r/ratio.md) instead. Integer division is often used together with the operator [mod](../m/mod.md) for grouping data. The results of `div` and `mod` should satisfy the relationship: `X=div(X,Y)*Y+mod(X,Y)`.

## Examples {#examples}

```
9/2:5;
// output: 4 : 1

11:25/3:4;
// output: 3 : 6

x=1 2 3;
x/2;
// output: [0,1,1]

2/x;
// output: [2,1,0]

y=4 5 6;
x/y;
// output: [0,0,0]
y/x;
// output: [4,2,2]

m1=1..6$2:3;
m1;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
m1/2;
```

|\#0|\#1|\#2|
|---|---|---|
|0|1|2|
|1|2|3|

```
m2=6..1$2:3;
m2;
```

|\#0|\#1|\#2|
|---|---|---|
|6|4|2|
|5|3|1|

```
m1/m2;
```

|\#0|\#1|\#2|
|---|---|---|
|0|0|2|
|0|1|6|

```
-7/5;
// output: -2


x=-1 2 6;
x/-5;
// output: [0,-1,-2]
```

