# distance {#distance}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#sytanx}

`distance(X, Y)`

## Arguments {#arguments}

**X** and **Y** can be a POINT scalar/pair/vector representing points in the coordinate system of earth.

## Details {#details}

Calculate the distance in meters between 2 points on the earth's surface.

## Examples {#examples}

```
p1 = point(180, 24.118418)
p2 = point(180, 24.11931)
distance(p1,p2)
// output: 99.185916

p1 = point(117.60972, 24.118418)
p2 = point(117.50972, 24.118418)
p3 = point(117.70972, 24.118418)
p4 = point(117.75972, 24.118418)
distance([p1,p2], [p3,p4])
```

|0|1|
|---|---|
|10,148.799|25,371.9947|

Calculate the distance between the two points p1 \(Lon1,Lat1\) and p2 \(Lon2,Lat2\) on the map. Based on the 0-degree longitude, the east longitude is taken as a positive value \(Longitude\), the west longitude is taken as a negative value \(-Longitude\), the north latitude is taken as 90-latitude, and the south latitude is taken as 90+latitude. So the calculation is:

```
p1 = point(-117.60972,24.118418)  //Longitude: 117.60972 W Latitude: 65.881582 N
p2 = point(117.61113,114.11931)  //Longitude: 117.60972 E Latitude: 24.118418 S
distance(p1,p2)
// output: 6.02098E6
```

