# disableTablePersistence {#disabletablepersistence}

## Syntax {#syntax}

`disableTablePersistence(table)`

## Arguments {#arguments}

**table** is a table object.

## Details {#details}

Disable a table persistence to disk. Any future update of the table will not be persisted to disk.

```
colName=["time","x"]
colType=["timestamp","int"]
t = streamTable(100:0, colName, colType);
share t as st
enableTablePersistence(table=st, cacheSize=1200000)
```

```
for(s in 0:200){
     n=10000
     time=2019.01.01T00:00:00.000+s*n+1..n
     x=rand(10.0, n)
     insert into st values(time, x)
}
disableTablePersistence(st);
```

Related commands: [enableTablePersistence](../e/enableTablePersistence.md), [clearTablePersistence](../c/clearTablePersistence.md)

