# dictUpdate! {#dictupdate}

## Syntax {#syntax}

`dictUpdate!(dictionary, function, keys, parameters, [initFunc=copy])`

## Arguments {#arguments}

**dictionary** is a dictionary object.

**function** is a function object.

**keys** is a scalar/vector indicating for which keys to apply the *function*.

**parameters** are of the same size as *keys*. The arguments passed to the applied function are *parameters* and the initial values of the dictionary.

**initFunc** \(optional\) is a unary function. If the update operation involves new keys that did not exist in the dictionary to be updated, execute *initFunc* for these keys. If *initFunc* is specified, the values of *dictionary* must be a tuple.

## Details {#details}

Update a dictionary for specified keys with the specified function.

## Examples {#examples}

```
x=dict(1 2 3, 1 1 1);
x;
/* output
3->1
1->1
2->1
*/

dictUpdate!(x, add, 2 3, 1 2);
/* output
3->3
1->1
2->2
*/

x.dictUpdate!(mul, 3 4, 2 4);
/* output
4->4
3->6
1->1
2->2
*/

d = dict(`IBM`MSFT, [1 2, 3 4])
msg = table(`IBM`MSFT`GOOG as symbol, 2 3 2 as ap)
d.dictUpdate!(append!, msg.symbol, msg.ap, x->array(x.type(), 0, 512).append!(x))
d;
/* output
MSFT->[3,4,3]
GOOG->[2]
IBM->[1,2,2]
*/
```

