# diag {#diag}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`diag(X)`

## Arguments {#arguments}

**X** is a numeric vector or a square matrix.

## Details {#details}

-   If *X* is a vector, return a diagonal matrix.
-   If *X* is a square matrix, return a vector with the diagonal elements of the matrix.

## Examples {#examples}

```
diag(1..5);
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1|0|0|0|0|
|0|2|0|0|0|
|0|0|3|0|0|
|0|0|0|4|0|
|0|0|0|0|5|

```
m=1..4$2:2;
m;
```

|\#0|\#1|
|---|---|
|1|3|
|2|4|

```
diag(m);
// output: [1,4]
```

