# derivative {#derivative}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`derivative(func, X, [dx =1.0], [n=1], [order=3])`

## Arguments {#arguments}

**func** is a unary function.

**X** is a numeric scalar/vector indicating where the derivative is evaluated.

**dx** \(optional\) is a scalar of FLOAT type indicating spacing. The default value is 1.0.

**n** \(optional\) is an integer scalar indicating the order of the derivative. As of now only *n*=1 is supported.

**order** \(optional\) is an integer scalar indicating the number of points to use. It must be an odd number. The default value is 3 and can be values between 3 and 1023.

## Details {#details}

Return the derivative of *func* of order *n* at *X*.

## Examples {#examples}

```
derivative(acos, 0.458, 1e-3);
// output: -1.12492

a=[0.25, -4.53, 1.85, 12.45, 2.0];
derivative(cbrt, a, 1e-3, 1, 5);
// output: [0.83995,0.121753,0.221189,0.062053,0.209987]

derivative(pow{3,}, 5);
// output: 324
```

