# deny {#deny}

## Syntax {#syntax}

`deny(userId|groupId,accessType,[objs])`

## Arguments {#id_vq1_chh_d2c}

**userId** \| **groupId** is a string indicating a user name or a group name.

**accessType** is the privilege type or memory limit.

**objs** \(optional\) is a STRING scalar/vector indicating the objects that the priviledges specified by *accessType* applies to. "\*" means all objects. When *accessType* is COMPUTE\_GROUP\_EXEC, *objs* must be compute group\(s\).

See the privilege table in [User Access Control](../g/../../Maintenance/UserAccessControl.md) for the values that *accessType* and *objs* can take.

**Note:**

-   When managing privileges for shared tables, stream tables or streaming engines, *objs* must be in the format "tableName@nodeAlias" or "nodeAlias:tableName".
-   When managing privileges for IMOLTP databases and tables, *objs* must be in the format "oltp://database/table@nodeAlias" or "oltp://database@nodeAlias".

## Details {#details}

Deny specified access privileges to a user or a group.

Administrators can grant users all privileges \(*accessType*\) through this command, but regular users, after having the relevant OWNER privileges, can only grant the following privileges through this command: TABLE\_READ, TABLE\_WRITE, TABLE\_INSERT, TABLE\_UPDATE, TABLE\_DELETE, DB\_READ, DB\_WRITE, DB\_INSERT, DB\_UPDATE, DB\_DELETE, DBOBJ\_DELETE, DBOBJ\_CREATE and VIEW\_EXEC.

For the types of permissions that can be denied, see [grant](../g/grant.md).

Note that when *accessType* is DB\_OWNER, `deny` only takes effect globally.

## Examples {#examples}

None of the members of the group "production" can read any table in the database *dfs://db1*:

```
deny(`production, TABLE_READ, "dfs://db1")
```

None of the members of the group "research" can write to the table *dfs://db1/t1*:

```
deny(`research, TABLE_WRITE, "dfs://db1/t1")
```

None of the members of the group "research" can create tables in the databases *dfs://db1* or *dfs://db2*:

```
deny("research", DBOBJ_CREATE, ["dfs://db1","dfs://db2"])
```

The user "AlexSmith" cannot create or delete databases:

```
deny("AlexSmith", DB_MANAGE)
```

The user "AlexSmith" cannot execute script:

```
deny("AlexSmith", SCRIPT_EXEC)
```

The user "AlexSmith" cannot test script:

```
deny("AlexSmith", TEST_EXEC)
```

