# denseRank {#denserank}

## Syntax {#syntax}

`denseRank(X, [ascending=true],[ignoreNA=true], [percent=false])`

## Arguments {#arguments}

**X** is a vector/matrix/dictionary.

**ascending** \(optional\) is a Boolean value indicating whether to sort in ascending order. The default value is true.

**ignoreNA** \(optional\) is a Boolean value indicating whether null values are ignored in ranking. The default value is true. If set to false, null values are ranked as the minimum value.

**percent** \(optional\) is a Boolean value, indicating whether to display the returned rankings in percentile form. The default value is false.

## Details {#details}

If *X* is a vector:

-   return the consecutive rank of each element in *X* based on the specified *ascending* order.

-   If *ignoreNA* = true, the null values are ignored in ranking and return NULL.


If *X* is a matrix, conduct the aforementioned calculation within each column of *X*. The result is a matrix with the same shape as *X*.

If *X* is a dictionary, the ranking is based on its values, and the ranks of all elements are returned.

Unlike `denseRank`, [rank](../r/rank.md) skips positions after equal rankings.

## Examples {#examples}

```
x=1 5 5 6 8 8 9
print denseRank(x)
// output: [0,1,1,2,3,3,4]

y=time(4 1 1 2)
print denseRank(y, ascending=false)
// output: [0,2,2,1]
m = matrix(1 2 2 NULL, 0 0 0 1, 0 0 NULL 2)
denseRank(m, ignoreNA=false)
```

|\#0|\#1|\#2|
|---|---|---|
|1|0|1|
|2|0|1|
|2|0|0|
|0|1|2|

```
t=table(`A`A`B`C`B`B`A`C`C as id,[4,1,NULL,1,2,4,5,0,-1] as val)
select id,val, denseRank(val) from t context by id
```

|id|val|denseRank\_val|
|---|---|--------------|
|A|4|1|
|A|1|0|
|A|5|2|
|B|||
|B|2|0|
|B|4|1|
|C|1|2|
|C|0|1|
|C|-1|0|

``` {#codeblock_p5m_rzd_ngc}
denseRank(dict(`a`b`c`d, [4, 1, 1,2],true))
// output: [2,0,0,1]
```

Related function: [rowDenseRank](../r/rowDenseRank.md)

