# deltas {#deltas}

## Syntax {#syntax}

`deltas(X, [n])`

## Arguments {#arguments}

**X** is a vector, matrix or table.

**n** \(optional\) is an integer specifying the step to shift when comparing elements in *X*. The default value is 1, meaning to compare the current element with the adjacent element at left.

## Details {#details}

For each element *Xi* in *X*, return *Xi*-*Xi-n*, representing the differences between elements.

**Return value**: A vector/matrix/table with the same shape as *X*.

## Examples {#examples}

```
x=7 4 5 8 9;
deltas(x);
// output: [,-3,1,3,1] 

x=NULL 1 2 NULL 3;
deltas(x);
// output: [,,1,,]

m=matrix(1 3 2 5 6, 0 8 NULL 7 6);
m;
```

|\#0|\#1|
|---|---|
|1|0|
|3|8|
|2||
|5|7|
|6|6|

```
deltas(m);
```

|\#0|\#1|
|---|---|
|||
|2|8|
|-1||
|3||
|1|-1|

When *n* is a positive integer:

``` {#codeblock_qmh_qhd_2bc}
m=matrix(1 3 2 5 6, 0 8 NULL 7 6);
a=deltas(m,2)
a;
```

|0|1|
|---|---|
|||
|||
|1||
|2|-1|
|4||

When n is a negative integer:

``` {#codeblock_ndg_shd_2bc}
m = 3 4 6 9
r2= deltas(m,-2)
r2; 
// output: [-3,-5,,]
```



