# defined {#defined}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`defined(names, [type=VAR])`

## Arguments {#arguments}

**names** is a STRING scalar/vector indicating object name\(s\).

**type** \(optional\) can be VAR \(variable, default\), SHARED \(shared variable\) or DEF \(function definitions\).

## Details {#details}

Return a scalar/vector indicating whether each element of names is defined.

## Examples {#examples}

```
x=10
y=20
def f(a){return a+1}
share table(1..3 as x, 4..6 as y) as t1;

defined(["x","y","f",`t1]);
// output: [1,1,0,0]

defined(["x","y","f",`t1], DEF);
// output: [0,0,1,0]

defined(["x","y","f",`t1], SHARED);
// output: [0,0,0,1]
```

