# decimalMultiply {#decimalmultiply}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#section_vqc_lcg_dzb}

`decimalMultiply(X, Y, scale)`

## Arguments {#section_ihb_mcg_dzb}

**X** and **Y** can be scalar or vector, and at least one argument is of DECIMAL type.

**scale** is a non-negative integer indicating the decimal places to be retained in the result.

## Details {#section_xmv_mcg_dzb}

The function multiplies Decimals. Compared with the [mul](../m/mul.md) function or operator [\*](../../Programming/Operators/OperatorReferences/mul.md), the function can set the decimal places of the result with *scale*.

Note: In the following situations, the specified scale does not take effect and the function is equivalent to operator `*`.

-   Only one argument is of DECIMAL type \(with scale S\), and the specified *scale* is not equal to S.
-   *X* and *Y* are both of DECIMAL type \(with scale S1 and S2, respectively\), and the specified *scale* is smaller than `min(S1, S2)` or greater than `(S1+S2)`.
-   One argument is a floating-point number.

For the first two situations, the function return a DECIMAL type result, and for the third situation it returns a result of DOUBLE type.

## Examples {#section_l25_rcg_dzb}

``` {#codeblock_ptg_tcg_dzb}
a = decimal32(`1.235, 3);
b = decimal32(`7.5689, 4);
c=decimalMultiply(a, b, 5)
// output: 9.34759

typestr(c)
// output: DECIMAL32

decimalMultiply(a, b, 2)   // As scale is smaller than min(3,4), the operation is equivalent to a*b.
// output: 9.3475915

b=float(`7.5689)
c=decimalMultiply(a, b, 5)   // As b is a floating-point number, the operation is equivalent to a*b and returns a result of DOUBLE type.
// output: 9.3475916337
typestr(c)
// output: DOUBLE
```

If the calculation result of a multiplication operation \(`*`\) or decimalMultiply overflows, it is automatically converted to type with higher precision. If the conversion fails, an exception will be thrown.

``` {#codeblock_qtg_tcg_dzb}
x = decimal32(1\7, 8)
y = decimal32(1\6, 8)
z = x * y
z
// output: 0.0238095223809524
typestr z
// output
DECIMAL64

z = decimalMultiply(x, y, 8)
z
// output: 0.02380952
typestr z
// output: DECIMAL64

x = decimal128(1\7, 35)
y = decimal128(1\6, 35)
x*y
x * y => Scale out of bound (valid range: [0, 38], but get: 70)

decimalMultiply(x, y, 35)
decimalMultiply(x, y, 35) => Decimal math overflow
```

When X or Y is a vector:

``` {#codeblock_rtg_tcg_dzb}
x = [decimal32(3.213312, 3), decimal32(3.1435332, 3), decimal32(3.54321, 3)]
y = 2.1
decimalMultiply(x, y, 5)
// output: [6.7473,6.6003,7.440300000000001]

x = [decimal32(3.213312, 3), decimal32(3.1435332, 3), decimal32(3.54321, 3)]
y = [decimal64(4.312412, 3), decimal64(4.53231, 3), decimal64(4.31258, 3)]
decimalMultiply(x, y, 5)
// output: [13.85445,14.24407,15.27741]
```

