# decimalFormat {#decimalformat}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`decimalFormat(X, format)`

## Arguments {#arguments}

**X** is a scalar/vector of Integral or Floating type.

**format** is a string indicating the format to apply to *X*.

## Details {#details}

Apply a specified *format* to the given object.

**Return value**: a STRING scalar/vector.

|Symbol|Meaning|Notes|
|------|-------|-----|
|0|mandatory digit|note 1|
|\#|optional digit|note 2|
|.|decimal point||
|%|percent sign|note 3|
|E|separates mantissa and exponent in scientific notation.|note 4|
|,|grouping separator|note 5|
|;|separates the format for positive numbers and the format for negative numbers|note 6|

-   Note 1: The number of 0s before the decimal point means the minimum number of digits before the decimal point. In comparison, the number of 0s after the decimal point means the number of digits after the decimal point.

    ``` {#codeblock_pxz_fcg_dzb .python}
    decimalFormat(123,"0");
    // output: 123
    
    decimalFormat(123,"00000");
    // output: 00123
    
    decimalFormat(123.45,"0");
    // output: 123
    
    decimalFormat(123.45,"0.0");
    // output: 123.5
    
    decimalFormat(123.45,"0.000");
    // output: 123.450
    
    decimalFormat(123.45, ".0");
    // output: 123.5
    
    decimalFormat(0.45, ".0");
    // output: .5
    ```

-   Note 2: If 0s and \#s are used together after the decimal point, 0s must appear before \#s.

    ``` {#codeblock_th3_gcg_dzb .python}
    decimalFormat(123.45,"0.#");
    // output: 123.5
    
    decimalFormat(123.45,"0.###");
    // output: 123.45
    
    decimalFormat(123.456,"0.000###");
    // output: 123.456
    
    decimalFormat(123.456789110,"0.000###");
    // output: 123.456789
    
    decimalFormat(0.345, ".##");
    // output: .35
    ```

-   Note 3: % is always at the end of a format. % and E cannot both appear in a format.

    ``` {#codeblock_v1x_gcg_dzb .python}
    decimalFormat(0.125,"0.00%");
    // output: 12.50%
    
    decimalFormat(0.125, "#.##%");
    // output: 12.5%
    
    decimalFormat(0.12567,"#.##%");
    // output: 12.57%
    ```

-   Note 4: "E" is followed by at least one 0 and 0s only.

    ``` {#codeblock_qy4_hcg_dzb .python}
    decimalFormat(1234567.89,"0.##E00");
    // output: 1.23E06
    
    decimalFormat(0.0000000000123456789,"0.000E0");
    // output: 1.235E-11
    ```

-   Note 5: The grouping separator may only appear at most once in the parameter *format*. The number of digits between the grouping separator and the decimal point \(if the decimal point is used\) or the end of the format \(if the decimal point is not used\) determines the number of digits between grouping separators in the result.

    ``` {#codeblock_umw_hcg_dzb .python}
    decimalFormat(123456789,"#,###");
    // output: 123,456,789
    
    decimalFormat(123456789.166,"#,###.##");
    // output: 123,456,789.17
    
    decimalFormat(123456789.166,"0,000.00");
    // output: 123,456,789.17
    ```

-   Note 6: If we prefer to apply different formats to an object depending on whether it is positive or negative, we can use ";" to seperate the 2 formats.

    ``` {#codeblock_cqk_3cg_dzb .python}
    decimalFormat(123.456,"0.00#E00;(0.00#E00)");
    // output: 1.235E02
    
    decimalFormat(-123.456,"0.00#E00;(0.00#E00)");
    // output: (1.235E02)
    ```


