# decimal32 {#decimal32}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`decimal32(X, scale)`

## Arguments {#arguments}

**X** is a scalar/vector of Integral, Floating, or STRING type.

**scale** is an integer in \[0,9\] that determines the number of digits to the right of the decimal point.

## Details {#details}

Convert the input values into DECIMAL32 type.

## Examples {#examples}

```
a=decimal32(142, 2)
a
// output: 142.00

b=decimal32(1\7, 6)
b
// output: 0.142857

a+b
// output: 142.142857

a*b
// output: 20.28569400

decimal32("3.1415926535", 4)
// output: 3.1415

// the elements of a DECIMAL vector must be of the same decimal type and scale
d1=[1.23$DECIMAL32(4), 3$DECIMAL32(4), 3.14$DECIMAL32(4)];
// output: [1.2300,3.0000,3.1400]
typestr(d1)
// output: FAST DECIMAL32 VECTOR

d2=[1.23$DECIMAL32(4), 3$DECIMAL32(4), 3.14$DECIMAL32(3)];
// output: (1.2300,3.0000,3.140)
typestr(d2)
// output: ANY VECTOR
```

**Note:** When converting data of STRING/SYMBOL type into DECIMAL, there has been a modification in the way the decimal part exceeding the scale is handled since version 2.00.10.

-   Before version 2.00.10, the decimal part is truncated;

-   Starting from version 2.00.10, the decimal part is rounded.


``` {#codeblock_rmc_ybg_dzb .python}
symbol(["1.341", "4.5677"])$DECIMAL32(2)
//before version 2.00.10, the output is: [1.34,4.56]
//starting from version 2.00.10, the output turns to: [1.34,4.57]
```

