# dayOfYear {#dayofyear}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`dayOfYear(X)`

## Arguments {#arguments}

**X** is a scalar/vector of type DATE, DATETIME, TIMESTAMP or NANOTIMESTAMP.

## Details {#details}

Return the day of the year for each element in *X*.

**Return value**: an integer

## Examples {#examples}

```
dayOfYear(2011.01.01);
// output: 1

dayOfYear([2011.12.31,2012.12.31]);
// output: [365,366]

dayOfYear([2012.06.12T12:30:00,2012.07.12T12:35:00]);
// output: [164,194]
```

Related functions: [dayOfMonth](dayOfMonth.md), [quarterOfYear](../q/quarterOfYear.md), [monthOfYear](../m/monthOfYear.md), [weekOfYear](../w/weekOfYear.md), [hourOfDay](../h/hourOfDay.md), [minuteOfHour](../m/minuteOfHour.md), [secondOfMinute](../s/secondOfMinute.md), [millisecond](../m/millisecond.md), [microsecond](../m/microsecond.md), [nanosecond](../n/nanosecond.md)

