# DStream::timerEngine {#DStream_timerEngine}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`DStream::timerEngine(interval, func, args...)`

## Arguments {#arguments}

**interval** An INTEGRAL scalar representing the time interval \(in second\) between job executions.

**func** A FUNCTIONDEF scalar representing the scheduled job.

**args…** The parameter passed to *func*, used similarly to the *args…* parameter of the remote procedure call function [rpc](https://docs.dolphindb.com/en/Functions/r/rpc.html). Can be omitted when *func* is a parameterless function.

## Details {#details}

Define a time-triggered engine to periodically execute *func* at intervals. This job does not block or modify the data flow of the stream graph.

## Examples {#examples}

Submit the job:

``` {#codeblock_cbz_tdv_mgc}
if (!existsCatalog("test")) {
	createCatalog("test")	
}
go
use catalog test

// Define the job
def myFunc(x,y,z){
    writeLog(x,y,z)
}

// Define the parameter
a = "aaa"
b = "bbb"
c = "ccc"

// Submit the steam graph
g = createStreamGraph("timerEngineDemo")
g.source("trade", `id`price, [INT, DOUBLE])
 .timerEngine(3, myFunc, a, b, c)
 .setEngineName("myJob")
 .sink("result")
g.submit()
```

Stop job execution:

``` {#codeblock_pvf_vdv_mgc}
useOrcaStreamEngine("myJob", stopTimerEngine)
```

Resume job execution:

``` {#codeblock_dbz_tdv_mgc}
useOrcaStreamEngine("myJob", resumeTimerEngine)
```

**Related functions:**[resumeTimerEngine](../r/resumeTimerEngine.md), [stopTimerEngine](../s/stopTimerEngine.md)

