# DStream::sink {#DStream_sink}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`DStream::sink(dest|name, [asyncWrite=true], [compress=true], [cacheSize], [retentionMinutes=1440], [flushMode=0], [cachePurgeTimeColumn], [cachePurgeInterval], [cacheRetentionTime])`

## Arguments {#arguments}

**dest \| name** The destination for the output stream, which can be:

-   A string specifying the fully qualified name of the target stream table or DFS table \(e.g., "trading.orca\_table.factors", "trading.dbName.tableName"\) or the DFS table path \(e.g., "dfs://dbName/tableName"\).
-   A unary function that takes the stream table as input, whose return value will be ignored.

**asyncWrite** \(optional\) is a Boolean value indicating whether persistence is enabled in asynchronous mode. The default value is true, meaning asynchronous persistence is enabled. In this case, once data is written into memory, the write is deemed complete. The data stored in memory is then persisted to disk by another thread.

**compress** \(optional\) is a Boolean value indicating whether to save a table to disk in compression mode. The default value is true.

**cacheSize** \(optional\) is an integer used to determine the maximum number of records to retain in memory. If set to 0 or not specified, all records will be retained. Any positive integer smaller than 1000 will automatically be adjusted to 1000.

**retentionMinutes** \(optional\) is an integer indicating for how long \(in minutes\) a log file larger than 1GB will be kept after last update. The default value is 1440, which means the log file is kept for 1440 minutes, i.e., 1 day.

**flushMode** \(optional\) is an integer indicating whether to enable synchronous disk flush. It can be 0 or 1. The persistence process first writes data from memory to the page cache, then flushes the cached data to disk. If *flushMode* is 0 \(default\), asynchronous disk flushing is enabled. In this case, once data is written from memory to the page cache, the flush is deemed complete and the next batch of data can be written to the table. If *flushMode* is set to 1, the current batch of data must be flushed to disk before the next batch can be written.

**preCache** \(optional\) is an integer indicating the number of records to be loaded into memory from the persisted stream table on disk when DolphinDB restarts. If it is not specified, all records are loaded into memory when DolphinDB restarts.

**cachePurgeTimeColumn** \(optional\) is a STRING scalar indicating the time column in the stream table.

**cachePurgeInterval** \(optional\) is a DURATION scalar indicating the interval to trigger cache purge.

**cacheRetentionTime** \(optional\) is a DURATION scalar indicating the retention time of cached data. Note: Since version 3.00.2/2.00.14, *cacheRetentionTime* must be smaller than *cachePurgeInterval*.

## Details {#details}

Outputs the stream data to a persisted and shared stream table, a DFS table, or a function.

For more information on table persistence, refer to the [enableTableShareAndPersistence](../e/enableTableShareAndPersistence.md) documentation.

**Return value**: A DStream object.

