# DStream::latestKeyedSink {#DStream_latestKeyedSink}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`DStream::latestKeyedSink(name, keyColumn, timeColumn, [asyncWrite=true], [compress=true], [cacheSize], [retentionMinutes=1440], [flushMode=0], [preCache], [cachePurgeTimeColumn], [cachePurgeInterval], [cacheRetentionTime])`

## Arguments {#arguments}

**name** A string specifying the name of the target stream table.

**keyColumn** is a string scalar or vector indicating the name of the primary key columns \(which must be of INTEGRAL, TEMPORAL, LITERAL or FLOATING type\).

**timeColumn** specifies the time column\(s\) and can be either:

-   A string indicates a single column of integral or temporal type, or
-   A two-element vector indicates two columns that combine to form a unique timestamp: a DATE column and a TIME, SECOND, or NANOTIME column.

**asyncWrite** \(optional\) is a Boolean value indicating whether persistence is enabled in asynchronous mode. The default value is true, meaning asynchronous persistence is enabled. In this case, once data is written into memory, the write is deemed complete. The data stored in memory is then persisted to disk by another thread.

**compress** \(optional\) is a Boolean value indicating whether to save a table to disk in compression mode. The default value is true.

**cacheSize** \(optional\) is an integer used to determine the maximum number of records to retain in memory. If set to 0 or not specified, all records will be retained. Any positive integer smaller than 1000 will automatically be adjusted to 1000.

**retentionMinutes** \(optional\) is an integer indicating for how long \(in minutes\) a log file larger than 1GB will be kept after last update. The default value is 1440, which means the log file is kept for 1440 minutes, i.e., 1 day.

**flushMode** \(optional\) is an integer indicating whether to enable synchronous disk flush. It can be 0 or 1. The persistence process first writes data from memory to the page cache, then flushes the cached data to disk. If *flushMode* is 0 \(default\), asynchronous disk flushing is enabled. In this case, once data is written from memory to the page cache, the flush is deemed complete and the next batch of data can be written to the table. If *flushMode* is set to 1, the current batch of data must be flushed to disk before the next batch can be written.

**preCache** \(optional\) is an integer indicating the number of records to be loaded into memory from the persisted stream table on disk when DolphinDB restarts. If it is not specified, all records are loaded into memory when DolphinDB restarts.

**cachePurgeTimeColumn** \(optional\) is a STRING scalar indicating the time column in the stream table.

**cachePurgeInterval** \(optional\) is a DURATION scalar indicating the interval to trigger cache purge.

**cacheRetentionTime** \(optional\) is a DURATION scalar indicating the retention time of cached data. Note: Since version 3.00.2/2.00.14, *cacheRetentionTime* must be smaller than *cachePurgeInterval*.

## Details {#details}

Outputs stream data to a persisted keyed stream table that retains only the latest record for each unique primary key based on a time column.

For more information on latest keyed stream tables, refer to the [latestKeyedStreamTable](../l/latestKeyedStreamTable.md) documentation.

**Return value**: A DStream object.

