# DStream::getOutputSchema {#DStream_getOutputSchema}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`DStream::getOutputSchema()`

## Arguments {#arguments}

None

## Details {#details}

Returns the schema of the current DStream object.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
aggGraph = createStreamGraph("aggregation")
engine = aggGraph.source("trade", 1000:0, `time`sym`price, [TIMESTAMP, SYMBOL, FLOAT])
	.timeSeriesEngine(windowSize=60, step=60, metrics=[<sum(price)>], 
timeColumn="time", keyColumn="sym")
engine.getOutputSchema()

/* output:
time sym sum_price
---- --- ---------
*/
```

