# cutPoints {#cutpoints}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`cutPoints(X, binNum, [freq])`

## Arguments {#arguments}

**X** is a vector.

**binNum** is the number of buckets to be formed.

**freq** \(optional\) is a vector with the same size as *X*. It specifies the frequency for each element in *X*. If it is specified, all the elements in *X* must be unique and sorted in ascending order.

## Details {#details}

Return a vector with \(*binNum*+1\) elements such that the elements of *X* are evenly distributed within each of the *binNum* buckets indicated by the vector. Each bucket is defined by two adjacent elements of the vector. The lower bound is inclusive and the upper bound is exclusive.

The function can be used to get the partition scheme of a range domain in a distributed database.

## Examples {#examples}

```
cutPoints(2 3 1 4, 2);
// output: [1,3,5]

cutPoints(1 2 3 4, 2, 1 1 1 3);
// output: [1,4,5]
```

