# curvePredict {#curvePredict}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#topic_cdc_r2r_ngc}

`curvePredict(curve, dt)`

## Details {#topic_ddc_r2r_ngc}

Predicts the curve value at the specified point\(s\) \(specified by *dt*\) on the given curve. Currently support only zero coupon yield curve.

**Return value**: A DOUBLE scalar/vector.

## Arguments {#topic_edc_r2r_ngc}

**curve** is a MKTDATA object of IrYieldCurve type.

**dt** is a DOUBLE scalar/vector or a DATE scalar/vector.

-   A DOUBLE scalar/vector indicates time in years.

-   A DATE scalar/vector indicates specific date\(s\).


## Examples {#topic_gdc_r2r_ngc}

``` {#codeblock_hdc_r2r_ngc}
curveDict = {
    "mktDataType": "Curve",
    "curveType": "IrYieldCurve",
    "referenceDate": 2025.08.18,
    "currency": "CNY",
    "dayCountConvention": "ActualActual",
    "compounding": "Continuous",  
    "interpMethod": "Linear",
    "extrapMethod": "Flat",
    "frequency": "Annual",
    "dates": [2025.08.21,
              2025.08.27,
              2025.09.03,
              2025.09.10,
              2025.09.22,
              2025.10.20,
              2025.11.20,
              2026.02.24,
              2026.05.20,
              2026.08.20,
              2027.02.22,
              2027.08.20,
              2028.08.21],
    "values":[1.5113, 
              1.5402, 
              1.5660, 
              1.5574, 
              1.5556, 
              1.5655, 
              1.5703, 
              1.5934, 
              1.6040, 
              1.6020, 
              1.5928, 
              1.5842, 
              1.6068]/100
}

curve = parseMktData(curveDict)

curvePredict(curve, 2025.10.18)

// output: 0.0156

curvePredict(curve, 1.0)
// output: 0.0160

print curvePredict(curve, [2025.10.18, 2026.10.18])
// output: [0.0156,0.0159]

print curvePredict(curve, [1.0, 2.0])
// output: [0.0160,0.0158]
```

**Related function:**[parseMktData](../p/parseMktData.md)

